<?php

/* setup includes */
require_once('includes/master.inc.php');

/* require login */
$Auth->requireUser('login.php');

// setup initial params
$s = (int)$_REQUEST['iDisplayStart'];
$l = (int)$_REQUEST['iDisplayLength'];
$sortCol = (int)$_REQUEST['iSortCol_0'];
$sortDir = $_REQUEST['sSortDir_0']=='asc'?'asc':'desc';
$sSearch = trim($_REQUEST['filterText']);
$filterByStatus = (int)$_REQUEST['filterByStatus'];
$filterByFolder = (int)$_REQUEST['filterByFolder'];

$db = Database::getDatabase(true);
$clause = "WHERE userId = " . (int)$Auth->id;
if(strlen($sSearch))
{
    $clause .= " AND (originalFilename LIKE '%".$db->escape($sSearch)."%' OR shortUrl LIKE '%".$db->escape($sSearch)."%')";
}

if($filterByStatus > 0)
{
    $clause .= " AND statusId = ".$filterByStatus." ";
}

if($filterByFolder > 0)
{
    $clause .= " AND folderId = ".$filterByFolder." ";
}

$sortColName = 'originalFilename';
switch($sortCol)
{
    case 1:
        $sortColName = 'originalFilename';
        break;
    case 2:
        $sortColName = 'uploadedDate';
        break;
    case 3:
        $sortColName = 'visits';
        break;
}

// get file total for this account and filter
$allFiles = $db->getValue('SELECT COUNT(id) AS total FROM file '.$clause);

// load limited page filtered
$files = $db->getRows('SELECT * FROM file '.$clause.' ORDER BY '.$sortColName.' '.$sortDir.' LIMIT '.$s.','.$l);

$data = array();
if ($files)
{
    foreach ($files AS $file)
    {
        $lrs = array();
        $statusLabel = file::getStatusLabel($file['statusId']);

        $fileTypePath = DOC_ROOT . '/themes/' . SITE_CONFIG_SITE_THEME . '/images/file_icons/32px/' . strtolower($file['extension']) . '.png';
        if (file_exists($fileTypePath))
        {
            $lrs[] = '<img src="' . SITE_IMAGE_PATH . '/file_icons/32px/' . strtolower($file['extension']) . '.png" width="32" height="32" title="' . strtolower($file['extension']) . ' file"/>';
        }
        else
        {
            $lrs[] = '';
        }

        $link = '';
        if ($file['statusId'] == 1)
        {
            $link .= '<a href="' . file::getFileUrl($file['id']) . '" target="_blank">';
        }
        $urlName = str_replace(array('http://', 'https://'), '', file::getFileUrl($file['id']));
        $urlName = wordwrap($urlName, 60, "<br/>", true);
        $link .= $urlName;
        if ($file['statusId'] == 1)
        {
            $link .= '</a>';
        }
        
        $originalFilename = wordwrap($file['originalFilename'], 60, "<br/>", true);
        $link .= '<br/><span style="color: #999;">' . $originalFilename;
        $link .= '&nbsp;(' . formatSize($file['fileSize']) . ')</span>';
        $lrs[] = $link;

        $lrs[] = dater($file['uploadedDate']) . '<br/>' . dater($file['lastAccessed']);
        $lrs[] = $file['visits'];
        $lrs[] = $statusLabel;

        $links = array();
        if ($statusLabel == 'active')
        {
            $links[] = '<a href="' . WEB_ROOT . '/account_edit_item.' . SITE_CONFIG_PAGE_EXTENSION . '?u=' . $file['id'] . '"><img src="' . SITE_IMAGE_PATH . '/edit.png" width="16" height="16" title="edit item" style="margin:1px;"/></a>';
        }
        $links[] = '<a href="' . file::getFileStatisticsUrl($file['id']) . '"><img src="' . SITE_IMAGE_PATH . '/chart_pie.png" width="16" height="16" title="download stats" style="margin:1px;"/></a>';
        if ($statusLabel == 'active')
        {
            $links[] = '<a href="' . file::getFileInfoUrl($file['id']) . '"><img src="' . SITE_IMAGE_PATH . '/group.png" width="16" height="16" title="share" style="margin:1px;"/></a>';
        }
        if ($statusLabel == 'active')
        {
            $links[] = '<a href="' . file::getFileDeleteUrl($file['id']) . '"><img src="' . SITE_IMAGE_PATH . '/delete.png" width="16" height="16" title="remove file" style="margin:1px;"/></a>';
        }
        $lrs[]   = implode("&nbsp;", $links);

        $data[] = $lrs;
    }
}

// create json response
$result = array();
$result['sEcho']                = intval($_GET['sEcho']);
$result['iTotalRecords']        = $allFiles;
$result['iTotalDisplayRecords'] = $allFiles;
$result['aaData']               = $data;

echo json_encode($result);