<script>
    var fileUrls = [];
    var fileDeleteHashes = [];
    var fileShortUrls = [];
    var lastEle = null;
    var startTime = null;
    var fileToEmail = '';
    var filePassword = '';
    var uploadComplete = false;
    $(document).ready(function() {
        'use strict';
<?php
if ($showUploads == true)
{
    // figure out max files
    $maxFiles = SITE_CONFIG_FREE_USER_MAX_CONCURRENT_UPLOADS;
    if($Auth->loggedIn())
    {
        if(($Auth->level == 'paid user') || ($Auth->level == 'admin'))
        {
            $maxFiles = SITE_CONFIG_PREMIUM_USER_MAX_CONCURRENT_UPLOADS;
        }
    }
    
    // failsafe
    if((int)$maxFiles == 0)
    {
        $maxFiles = 50;
    }
    ?>
            // Initialize the jQuery File Upload widget:
            $('#fileUpload #fileupload').fileupload({
                sequentialUploads: true,
                url: '<?php echo file::getUploadUrl(); ?>/uploadHandler.php?r=<?php echo htmlspecialchars(_CONFIG_SITE_HOST_URL); ?>&p=<?php echo htmlspecialchars(_CONFIG_SITE_PROTOCOL); ?>',
                maxFileSize: <?php echo $maxUploadSize; ?>,
                formData: {_sessionid: '<?php echo session_id(); ?>'},
                xhrFields: {
                    withCredentials: true
                },
    <?php echo COUNT($acceptedFileTypes) ? ('acceptFileTypes: /(\\.|\\/)(' . str_replace(".", "", implode("|", $acceptedFileTypes) . ')$/i,')) : ''; ?> maxNumberOfFiles: <?php echo (int)$maxFiles; ?>
                    })
                    .on('fileuploadadd', function(e, data) {
                        $('#fileUpload #fileupload #fileListingWrapper').removeClass('hidden');
                        $('#fileUpload #fileupload #initialUploadSection').addClass('hidden');
                        $('#fileUpload #fileUploadBadge').addClass('hidden');
            
                        // fix for safari
                        getTotalRows();
                        // end safari fix

                        totalRows = getTotalRows()+1;
                        updateTotalFilesText(totalRows);
    		
                    })
                    .on('fileuploadstart', function(e, data) {
                        // hide/show sections
                        $('#fileUpload #addFileRow').addClass('hidden');
                        $('#fileUpload #processQueueSection').addClass('hidden');
                        $('#fileUpload #processingQueueSection').removeClass('hidden');
            
                        // set all cancel icons to processing
                        $('#fileUpload .cancel').html('<img class="processingIcon" src="<?php echo SITE_IMAGE_PATH; ?>/processing_small.gif" width="16" height="16"/>');
            
                        // set timer
                        startTime = (new Date()).getTime();
                    })
                    .on('fileuploadstop', function(e, data) {
                        // finished uploading
                        updateTitleWithProgress(100);
                        updateProgessText(100, data.total, data.total);
                        $('#fileUpload #processQueueSection').addClass('hidden');
                        $('#fileUpload #processingQueueSection').addClass('hidden');
                        $('#fileUpload #completedSection').removeClass('hidden');

                        // set all remainging pending icons to failed
                        $('#fileUpload .processingIcon').parent().html('<img src="<?php echo SITE_IMAGE_PATH; ?>/red_error_small.png" width="16" height="16"/>');

                        uploadComplete = true;
                        sendAdditionalOptions();

                        // setup copy link
                        setupCopyAllLink();
                    })
                    .on('fileuploadprogressall', function(e, data) {
                        // progress bar
                        var progress = parseInt(data.loaded / data.total * 100, 10);
                        $('#progress .bar').css(
                            'width',
                            progress + '%'
                        );
            
                        // update page title with progress
                        updateTitleWithProgress(progress);
                        updateProgessText(progress, data.loaded, data.total);
                    })
                    .on('fileuploaddone', function(e, data) {
                        // keep a copy of the urls globally
                        fileUrls.push(data['result'][0]['url']);
                        fileDeleteHashes.push(data['result'][0]['delete_hash']);
                        fileShortUrls.push(data['result'][0]['short_url']);

                        var isSuccess = true;
                        if(data['result'][0]['error'] != null)
                        {
                            isSuccess = false;
                        }

                        var html = '';
                        html += '<tr class="template-download';
                        if(isSuccess == false)
                        {
                            html += ' errorText';
                        }
                        html += '" ';
                        if(isSuccess == true)
                        {
                            html += 'onClick="return showAdditionalInformation(this);"';
                        }
                        html += '>';
                        
                        if(isSuccess == true)
                        {
                            html += data['result'][0]['success_result_html'];
                        }
                        else
                        {
                            html += data['result'][0]['error_result_html'];
                        }
                        html += '</tr>';
  
                        // update screen with success content
                        $(data['context'])
                            .replaceWith(html);
                    })
                    .on('fileuploadfail', function(e, data) {   
                        // update screen with success content
                        $(data['context']).find('.name')
                            .html('ERROR: There was a server problem when attempting the upload, please try again later.');
                    
                        totalRows = getTotalRows();
                        if(totalRows > 0)
                        {
                            totalRows = totalRows-1;
                        }

                        updateTotalFilesText(totalRows);
                    });

                    // Open download dialogs via iframes,
                    // to prevent aborting current uploads:
                    $('#fileUpload #fileupload #files a:not([target^=_blank])').on('click', function (e) {
                        e.preventDefault();
                        $('<iframe style="display:none;"></iframe>')
                        .prop('src', this.href)
                        .appendTo('body');
                    });

                    //$(".ui-dialog-buttonpane").html("<div class='btn_bar_left'><div class='fileupload-progressbar'></div></div>"+$(".ui-dialog-buttonpane").html());
    <?php
}
?>
        
        $('.showAdditionalOptionsLink').click(function (e) {
            // show panel
            showAdditionalOptions();
            
            // prevent background clicks
            e.preventDefault();

            return false;
        });
    });
    
    $(function() {
        $("#tabs").tabs();
        $("#tabs").mouseover(function() {
            $("#tabs").addClass("tabsHover");
        });
        
        $("#tabs").mouseout(function() {
            $("#tabs").removeClass("tabsHover");
        });
    });

    function setupCopyAllLink()
    {
        // update text
        $('#copyAllLink').attr('data-clipboard-text', getUrlsAsText());
        
        // setup copy to clipboard
        var clip = new ZeroClipboard( document.getElementById("copyAllLink"), {
            moviePath: "<?php echo WEB_ROOT; ?>/js/zeroClipboard/ZeroClipboard.swf",
            text: getUrlsAsText()
          } );
          
        clip.on( 'complete', function(client, args) {
            alert("<?php echo t('links_copies_to_clipboard', 'Links copied to clipboard:\n\n'); ?>" + args.text );
        } );
    }

    function updateProgessText(progress, uploadedBytes, totalBytes)
    {
        // calculate speed & time left
        nowTime = (new Date()).getTime();
        loadTime = (nowTime - startTime);
        if(loadTime == 0)
        {
            loadTime = 1;
        }
        loadTimeInSec = loadTime/1000;
        bytesPerSec = uploadedBytes / loadTimeInSec;

        textContent = '';
        textContent += 'Progress: '+progress+'%';
        textContent += ' ';
        textContent += '('+bytesToSize(uploadedBytes, 2)+' / '+bytesToSize(totalBytes, 2)+')';
    
        $("#fileupload-progresstextLeft").html(textContent);
    
        rightTextContent = '';
        rightTextContent += 'Speed: '+bytesToSize(bytesPerSec, 2)+'ps. ';
        rightTextContent += 'Remaining: '+humanReadableTime((totalBytes/bytesPerSec)-(uploadedBytes/bytesPerSec));
    
        $("#fileupload-progresstextRight").html(rightTextContent);
    }

    function getUrlsAsText()
    {
        urlStr = '';
        for(var i=0; i<fileUrls.length; i++)
        {
            urlStr += fileUrls[i]+"\n";
        }

        return urlStr;
    }

    function updateTitleWithProgress(progress)
    {
        if(typeof(progress) == "undefined")
        {
            var progress = 0;
        }
        if(progress == 0)
        {
            $(document).attr("title", "<?php echo PAGE_NAME; ?> - <?php echo SITE_CONFIG_SITE_NAME; ?>");
        }
        else
        {
            $(document).attr("title", progress+"% Uploaded - <?php echo PAGE_NAME; ?> - <?php echo SITE_CONFIG_SITE_NAME; ?>");
        }
    }

    function getTotalRows()
    {
        totalRows = $('#files .template-upload').length;
        if(typeof(totalRows) == "undefined")
        {
            return 0;
        }

        return totalRows;
    }

    function updateTotalFilesText(total)
    {
        // removed for now, might be useful in some form in the future
        //$('#uploadButton').html('upload '+total+' files');
    }

    function setRowClasses()
    {
        // removed for now, might be useful in some form in the future
        //$('#files tr').removeClass('even');
        //$('#files tr').removeClass('odd');
        //$('#files tr:even').addClass('odd');
        //$('#files tr:odd').addClass('even');
    }

    function showAdditionalInformation(ele)
    {
        // block parent clicks from being processed on additional information
        $('.sliderContent table').unbind();
        $('.sliderContent table').click(function(e){
            e.stopPropagation();
        });
	
        // make sure we've clicked on a new element
        if(lastEle == ele)
        {
            // close any open sliders
            $('.sliderContent').slideUp('fast');
            // remove row highlighting
            $('.sliderContent').parent().parent().removeClass('rowSelected');
            lastEle = null;
            return false;
        }
        lastEle = ele;

        // close any open sliders
        $('.sliderContent').slideUp('fast');

        // remove row highlighting
        $('.sliderContent').parent().parent().removeClass('rowSelected');

        // select row and popup content
        $(ele).addClass('rowSelected');

        // set the position of the sliderContent div
        $(ele).find('.sliderContent').css('left', 21);
        $(ele).find('.sliderContent').css('top', $(ele).offset().top-38<?php echo (_CONFIG_DEMO_MODE == true)?'-30':''; ?>);
        $(ele).find('.sliderContent').slideDown(400, function() {
        });

        return false;
    }

    function saveFileToFolder(ele)
    {
        // get variables
        shortUrl = $(ele).closest('.sliderContent').children('.shortUrlHidden').val();
        folderId = $(ele).val();
    
        // send ajax request
        var request = $.ajax({
            url: "<?php echo _CONFIG_SITE_PROTOCOL . '://' . _CONFIG_SITE_FULL_URL; ?>/_updateFolder.ajax.php",
            type: "POST",
            data: {shortUrl: shortUrl, folderId: folderId},
            dataType: "html"
        });
    }

    function showAdditionalOptions()
    {
        if($('#additionalOptionsWrapper').is(":visible"))
        {
            $('#additionalOptionsWrapper').slideUp();
        }
        else
        {
            $('#additionalOptionsWrapper').slideDown();
        }
    }
    
    function saveAdditionalOptions()
    {
        // save values globally
        fileToEmail = $('#send_via_email').val();
        filePassword = $('#set_password').val();
        
        // attempt ajax to save
        processAddtionalOptions();
        
        // hide
        showAdditionalOptions();
    }

    function processAddtionalOptions()
    {
        // make sure the uploads have completed
        if(uploadComplete == false)
        {
            return false;
        }
        
        return sendAdditionalOptions();
    }
    
    function sendAdditionalOptions()
    {
        // make sure we have some urls
        if(fileDeleteHashes.length == 0)
        {
            return false;
        }
        
        // make sure we have pending email
        if((fileToEmail.length == 0) && (filePassword.length == 0))
        {
            return false;
        }
        
        $.ajax({
            type: "POST",
            url: "<?php echo WEB_ROOT; ?>/_updateFileOptions.ajax.php",
            data: { fileToEmail: fileToEmail, filePassword: filePassword, fileDeleteHashes: fileDeleteHashes, fileShortUrls: fileShortUrls }
        }).done(function( msg ) {
            fileToEmail = '';
            filePassword = '';
        });
    }
</script>

<?php
if ($showUploads == true)
{
?>
<script>
    function findUrls(text)
    {
        var source = (text || '').toString();
        var urlArray = [];
        var url;
        var matchArray;

        // Regular expression to find FTP, HTTP(S) and email URLs.
        var regexToken = /(((ftp|https?):\/\/)[\-\w@:%_\+.~#?,&\/\/=]+)|((mailto:)?[_.\w-]+@([\w][\w\-]+\.)+[a-zA-Z]{2,3})/g;

        // Iterate through any URLs in the text.
        while( (matchArray = regexToken.exec( source )) !== null )
        {
            var token = matchArray[0];
            urlArray.push( token );
        }

        return urlArray;
    }
    
    function urlUploadFiles()
    {
        // get textarea contents
        urlList = $('#urlList').val();
        if(urlList.length == 0)
        {
            alert('<?php echo str_replace("'", "\'", t('please_enter_the_urls_to_start', 'Please enter the urls to start.')); ?>');
            return false;
        }
        
        // get file list as array
        urlList = findUrls(urlList);
    
        // first check to make sure we have some urls
        if(urlList.length == 0)
        {
            alert('<?php echo str_replace("'", "\'", t('no_valid_urls_found_please_make_sure_any_start_with_http_or_https', 'No valid urls found, please make sure any start with http or https and try again.')); ?>');
            return false;
        }
        
        // make sure the user hasn't entered more than is permitted
        if(urlList.length > <?php echo (int)$maxPermittedUrls; ?>)
        {
            alert('<?php echo str_replace("'", "\'", t('you_can_not_add_more_than_x_urls_at_once', 'You can not add more than [[[MAX_URLS]]] urls at once.', array('MAX_URLS'=>(int)$maxPermittedUrls))); ?>');
            return false;
        }
        
        // create table listing
        html = '';
        for(i in urlList)
        {
            html += '<tr id="rowId'+i+'"><td class="cancel"><a href="#" onClick="return false;"><img src="<?php echo SITE_IMAGE_PATH; ?>/processing_small.gif" class="processingIcon" height="16" width="16" alt="<?php echo str_replace("\"", "\\\"", t('processing', 'processing')); ?>"/>';
            html += '</a></td><td class="name" colspan="3">'+urlList[i]+'</td></tr>';
        }
        $('#urlUpload #urls').html(html);
                
        // show file uploader screen
        $('#urlUpload #urlFileListingWrapper').removeClass('hidden');
        $('#urlUpload #urlFileUploader').addClass('hidden');
        $('#urlUpload #fileUploadBadge').addClass('hidden');
        
        // loop over urls and try to retrieve the file
        for(i in urlList)
        {
            // call ajax request to get file
            var request = $.ajax({
                url: "<?php echo file::getUploadUrl(); ?>/urlUploadHandler.php",
                type: "POST",
                data: {url: urlList[i], rowId: i},
                dataType: "json",
                ysrowId: i,
                xhrFields: {
                    withCredentials: true
                 }
            });

            request.done(function(data) {
                isSuccess = true;
                if(data.error != null)
                {
                    isSuccess = false;
                }

                html = '';
                html += '<tr class="template-download';
                if(isSuccess == false)
                {
                    html += ' errorText';
                }
                html += '" onClick="return showAdditionalInformation(this);">'
                if(isSuccess == false)
                {
                    // add result html
                    html += data.error_result_html;
                }
                else
                {
                    // add result html
                    html += data.success_result_html;
                    
                    // keep a copy of the urls globally
                    fileUrls.push(data.url);
                    fileDeleteHashes.push(data.delete_hash);
                    fileShortUrls.push(data.short_url);
                }
                
                html += '</tr>';
                
                $('#rowId'+data.rowId).replaceWith(html);
                
                if(i == urlList.length-1)
                {
                    // show footer
                    $('#urlUpload .fileSectionFooterText').removeClass('hidden');
                    
                    // set additional options
                    sendAdditionalOptions();
                    
                    // setup copy link
                    setupCopyAllLink();
                }
            });

            request.fail(function(jqXHR, textStatus) {
                $('#rowId'+this.ysrowId+' .cancel .processingIcon').attr('src', '<?php echo SITE_IMAGE_PATH; ?>/red_error_small.png');
                $('#rowId'+this.ysrowId+' .name').html(urlList[this.ysrowId]+' (Failed to request file, possible ajax issue)');
            });
        }
    }
</script>
<?php
}
?>