<?php
/* setup includes */
require_once('includes/master.inc.php');

/* require login */
$Auth->requireUser('login.php');

/* remove file */
if(isset($_REQUEST['d']))
{
    $file = file::loadById($_REQUEST['d']);
    if ($file)
    {
        /* check user id */
        if ($file->userId == $Auth->id)
        {
            $file->removeByUser();
        }
    }
}

// defaults
$filterByStatus = 1;

// load all file status
$sQL           = "SELECT id, label FROM file_status ORDER BY label";
$statusDetails = $db->getRows($sQL);

// load all folders
$sQL           = "SELECT id, folderName FROM file_folder WHERE userId = ".(int)$Auth->id." ORDER BY folderName";
$folderDetails = $db->getRows($sQL);

/* setup page */
define("PAGE_NAME", t("account_home_page_name", "Account Home"));
define("PAGE_DESCRIPTION", t("account_home_meta_description", "Your Account Home"));
define("PAGE_KEYWORDS", t("account_home_meta_keywords", "account, home, file, your, interface, upload, download, site"));

require_once('_header.php');

// load all files for this account
$files = file::loadAllByAccount($Auth->id);

// load all active files for this account
$activeFiles = file::loadAllActiveByAccount($Auth->id);
?>

<script>
    oTable = null;
    $(document).ready(function() {
        oTable = $('#fileData').dataTable( {
            "sPaginationType": "full_numbers",
            "aaSorting": [[ 1, "asc" ]],
            "bAutoWidth": false,
            "aoColumns": [
                { "bSortable": false, sClass: "alignCenter" },
                { "bSortable": true },
                { "bSortable": true, sClass: "alignCenter" },
                { "bSortable": true, sClass: "alignCenter" },
                { "bSortable": false, sClass: "alignCenter" },
                { "bSortable": false, sClass: "alignCenter" }
            ],
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": '_account_home.ajax.php',
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                var id = aData[0];
                $(nRow).attr("id", id);
                cellContents = aData[4];
                if (cellContents.substr(0,7) == 'expired')
                {
                    $(nRow).addClass('rowUrlExpired');
                }
                return nRow;
            },
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                aoData.push( { "name": "filterByFolder", "value": $('#filterByFolder').val() } );
                aoData.push( { "name": "filterByStatus", "value": $('#filterByStatus').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "_account_home.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            },
            "oLanguage": {
                "oPaginate": {
                    "sFirst": "<?php echo safeOutputToScreen(t('paging_first', 'First')); ?>",
                    "sLast": "<?php echo safeOutputToScreen(t('paging_last', 'Last')); ?>",
                    "sNext": "<?php echo safeOutputToScreen(t('paging_next', 'Next')); ?>",
                    "sPrevious": "<?php echo safeOutputToScreen(t('paging_previous', 'Previous')); ?>"
                },
                "sEmptyTable": "<?php echo safeOutputToScreen(t('datatable_empty', 'No data found.')); ?>",
                "sInfo": "<?php echo safeOutputToScreen(t('datatable_data_info', 'Showing _START_ to _END_ of _TOTAL_ entries')); ?>",
                "sLengthMenu": "<?php echo safeOutputToScreen(t('datatable_per_page', 'Show _MENU_ entries')); ?>"
            }
        } );
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
    } );
    
    function reloadTable()
    {
        oTable.fnDraw();
    }
</script>

<div class="contentPageWrapper">

    <!-- main section -->
    <div class="pageSectionMainFull ui-corner-all">
        <div class="pageSectionMainInternal">
            <div id="pageHeader">
                <h2><?php echo t("your_files", "Your Files"); ?></h2>
            </div>
            <div>
                <p class="introText">
                    <?php if (COUNT($activeFiles))
                    { ?>
                        You have <?php echo COUNT($activeFiles); ?> active file<?php echo (COUNT($activeFiles) != 1) ? 's' : ''; ?> within your account. Use the table below to navigate or search for files you've previously uploaded. <a href="index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Click here</a> to upload a file.
                    <?php }
                    else
                    { ?>
                        You have no active files within your account. <a href="index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Click here</a> to upload a file.
<?php } ?>
                    <br/><br/>
                </p>
            </div>
            <div class="clear"><!-- --></div>

            <div>
                <p class="introText">
                    <?php
                    if ($files)
                    {
                        echo '<table id="fileData" width="100%" cellpadding="3" cellspacing="0">';
                        echo '<thead>';
                        echo '<th style="width: 30px;" class="ui-state-default"></th>';
                        echo '<th class="ui-state-default">'.t('download_url_filename', 'Download Url/Filename:').'</th>';
                        echo '<th  style="width: 135px; text-align: center;"class="ui-state-default">'.t('uploaded_last_visited', 'Uploaded/Last Visited:').'</th>';
                        echo '<th style="width: 55px; text-align: center;" class="ui-state-default">'.t('downloads', 'Downloads:').'</th>';
                        echo '<th style="width: 65px; text-align: center;" class="ui-state-default">'.t('status', 'Status:').'</th>';
                        echo '<th style="width: 85px; text-align: center;" class="ui-state-default">'.t('options', 'Options:').'</th>';
                        echo '</thead>';
                        echo '<tbody>';
                        echo '</tbody>';
                        echo '</table>';
                    }
                    ?>
                </p>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        <?php echo t('filter_results', 'Filter Results'); ?>:
        <input name="filterText" id="filterText" type="text" value="<?php echo safeOutputToScreen($filterText); ?>" onKeyUp="reloadTable(); return false;" style="width: 160px;"/>
    </label>
    <label style="padding-left: 6px;">
        <?php echo t('by_folder', 'By Folder'); ?>:
        <select name="filterByFolder" id="filterByFolder" onChange="reloadTable(); return false;" style="width: 120px;">
            <option value="">- <?php echo t('all', 'all'); ?> -</option>
            <?php
            if (COUNT($folderDetails))
            {
                foreach ($folderDetails AS $folderDetail)
                {
                    echo '<option value="' . $folderDetail['id'] . '"';
                    if (($filterByFolder) && ($filterByFolder == $folderDetail['id']))
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . safeOutputToScreen($folderDetail['folderName']) . '</option>';
                }
            }
            ?>
        </select>
    </label>
    <label style="padding-left: 6px;">
        <?php echo t('by_status', 'By Status'); ?>:
        <select name="filterByStatus" id="filterByStatus" onChange="reloadTable(); return false;" style="width: 120px;">
            <option value="">- <?php echo t('all', 'all'); ?> -</option>
            <?php
            if (COUNT($statusDetails))
            {
                foreach ($statusDetails AS $statusDetail)
                {
                    echo '<option value="' . $statusDetail['id'] . '"';
                    if (($filterByStatus) && ($filterByStatus == $statusDetail['id']))
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . $statusDetail['label'] . '</option>';
                }
            }
            ?>
        </select>
    </label>
</div>

<?php
require_once('_footer.php');
?>