<?php

// includes and security
include_once('../_local_auth.inc.php');

// prepare variables
$server_label = '';
$status_id = '';
$server_type = '';
$ftp_host = '';
$ftp_port = 21;
$ftp_username = '';
$ftp_password = '';
$sftp_host = '';
$sftp_port = 22;
$sftp_username = '';
$sftp_password = '';
$storage_path = 'files/';
$formType = 'set the new';
$file_server_domain_name = '';
$script_path = '/';

// is this an edit?
$fileServerId = null;

if(isset($_REQUEST['gEditFileServerId']))
{
    $fileServerId = (int)$_REQUEST['gEditFileServerId'];
    if($fileServerId)
    {
        $sQL           = "SELECT * FROM file_server WHERE id=".$fileServerId;
        $serverDetails = $db->getRow($sQL);
        if($serverDetails)
        {
            $server_label = $serverDetails['serverLabel'];
            $status_id = $serverDetails['statusId'];
            $server_type = $serverDetails['serverType'];
            $ftp_host = $serverDetails['ipAddress'];
            $ftp_port = $serverDetails['ftpPort'];
            $ftp_username = $serverDetails['ftpUsername'];
            $ftp_password = $serverDetails['ftpPassword'];
            $sftp_host = $serverDetails['sftpHost'];
            $sftp_port = $serverDetails['sftpPort'];
            $sftp_username = $serverDetails['sftpUsername'];
            $sftp_password = $serverDetails['sftpPassword'];
            $storage_path = $serverDetails['storagePath'];
            $formType = 'update the';
            $file_server_domain_name = $serverDetails['fileServerDomainName'];
            $script_path = $serverDetails['scriptPath'];
        }
    }
}

// load all server statuses
$sQL           = "SELECT id, label FROM file_server_status ORDER BY label";
$statusDetails = $db->getRows($sQL);

// prepare whether we should disable local server or not
$isDefaultServer = false;
if($server_label == 'Local Default')
{
    $isDefaultServer = true;
}

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';
$result['html'] = 'Could not load the form, please try again later.';

$result['html']  = '<p style="padding-bottom: 4px;">Use the form below to '.$formType.' file server details.</p>';
$result['html'] .= '<span id="popupMessageContainer"></span>';
$result['html'] .= '<form id="addFileServerForm" class="form">';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("server_label", "server label")).':</label>
                        <div class="input">
                            <input name="server_label" id="server_label" type="text" value="'.adminFunctions::makeSafe($server_label).'" class="large" '.($isDefaultServer?'DISABLED':'').'/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("status", "status")).':</label>
                        <div class="input">
                            <select name="status_id" id="status_id">';
                                foreach($statusDetails AS $statusDetail)
                                {
                                    $result['html'] .= '        <option value="'.$statusDetail['id'].'"';
                                    if($status_id == $statusDetail['id'])
                                    {
                                        $result['html'] .= '        SELECTED';
                                    }
                                    $result['html'] .= '        >'.UCWords($statusDetail['label']).'</option>';
                                }
                                $result['html'] .= '        </select>
                        </div>
                    </div>';

$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("server_type", "server type")).':</label>
                        <div class="input">
                            <select name="server_type" id="server_type" class="xxlarge" onChange="showHideFTPElements(); return false;" '.($isDefaultServer?'DISABLED':'').'>
                                <option value="local"'.($server_type=='local'?' SELECTED':'').'>Local (storage located on the same server as your site)</option>
                                <option value="direct"'.($server_type=='direct'?' SELECTED':'').'>Remote Direct (users upload directly to remote file server)</option>
                                <option value="ftp"'.($server_type=='ftp'?' SELECTED':'').'>FTP (uses FTP via PHP to upload files into storage)</option>
                                <!--<option value="sftp"'.($server_type=='sftp'?' SELECTED':'').'>SFTP</option>-->
                            </select>
                        </div>
                    </div>';

$result['html'] .= '<span class="localElements" style="display: none;">';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("storage_path", "storage path")).':</label>
                        <div class="input">
                            <input name="storage_path" id="storage_path" type="text" value="'.adminFunctions::makeSafe($storage_path).'" class="large" '.($isDefaultServer?'DISABLED':'').'/>
                        </div>
                    </div>';
$result['html'] .= '</span>';

$result['html'] .= '<span class="ftpElements" style="display: none;">';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("ftp_host", "ftp host")).':</label>
                        <div class="input">
                            <input name="ftp_host" id="ftp_host" type="text" value="'.adminFunctions::makeSafe($ftp_host).'" class="large"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("ftp_port", "ftp port")).':</label>
                        <div class="input">
                            <input name="ftp_port" id="ftp_port" type="text" value="'.adminFunctions::makeSafe($ftp_port).'" class="small"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("ftp_username", "ftp username")).':</label>
                        <div class="input">
                            <input name="ftp_username" id="ftp_username" type="text" value="'.adminFunctions::makeSafe($ftp_username).'"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("ftp_password", "ftp password")).':</label>
                        <div class="input">
                            <input name="ftp_password" id="ftp_password" type="password" value="'.adminFunctions::makeSafe($ftp_password).'"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("storage_path", "storage path")).':</label>
                        <div class="input">
                            <input name="storage_path" id="storage_path" type="text" value="'.adminFunctions::makeSafe($storage_path).'" class="large"/>
                        </div>
                    </div>';
$result['html'] .= '</span>';

$result['html'] .= '<span class="sftpElements" style="display: none;">';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("sftp_host", "sftp host")).':</label>
                        <div class="input">
                            <input name="sftp_host" id="sftp_host" type="text" value="'.adminFunctions::makeSafe($sftp_host).'" class="large"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("sftp_port", "sftp port")).':</label>
                        <div class="input">
                            <input name="sftp_port" id="sftp_port" type="text" value="'.adminFunctions::makeSafe($sftp_port).'" class="small"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("sftp_username", "sftp username")).':</label>
                        <div class="input">
                            <input name="sftp_username" id="sftp_username" type="text" value="'.adminFunctions::makeSafe($sftp_username).'"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("sftp_password", "sftp password")).':</label>
                        <div class="input">
                            <input name="sftp_password" id="sftp_password" type="password" value="'.adminFunctions::makeSafe($sftp_password).'"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("storage_path", "storage path")).':</label>
                        <div class="input">
                            <input name="storage_path" id="storage_path" type="text" value="'.adminFunctions::makeSafe($storage_path).'" class="large"/>
                        </div>
                    </div>';
$result['html'] .= '</span>';

$result['html'] .= '<span class="directElements" style="display: none;">';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("file_server_domain_name", "file server domain name")).':</label>
                        <div class="input">
                            <input name="file_server_domain_name" id="file_server_domain_name" placeholder="i.e. fs1.yourdomain.com" type="text" value="'.adminFunctions::makeSafe($file_server_domain_name).'" class="xxlarge"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("upload_script_path", "upload script path")).':</label>
                        <div class="input">
                            <input name="script_path" id="script_path" type="text" placeholder="/ - root, unless you installed into a sub-folder" value="'.adminFunctions::makeSafe($script_path).'" class="xxlarge" onKeyUp="updateRewriteBase(this);"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>'.UCWords(adminFunctions::t("server_storage_path", "server storage path")).':</label>
                        <div class="input">
                            <input name="storage_path" id="storage_path" type="text" value="'.adminFunctions::makeSafe($storage_path).'" class="large"/>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>'.UCWords(adminFunctions::t("code_setup", "code setup")).':</label>
                        <span style="width:550px; display: inline-block; padding-top: 6px; padding-left: 20px;">
                            Direct file server requirements: PHP5.3+, Apache Mod Rewrite, remote access to your MySQL database.<br/><br/>
                            So your direct file server can receive the uploads and send downloads, it needs a copy of the codebase installed. Upload all the files on your main site to your new file server.<br/><br/>
                            Once uploaded, amend the _config.inc.php file with your local settings. You\'ll need to update _CONFIG_SITE_HOST_URL &amp; _CONFIG_SITE_FULL_URL.<br/><br/>_CONFIG_CORE_SITE_HOST_URL should remain as \''._CONFIG_SITE_HOST_URL.'\' and _CONFIG_CORE_SITE_FULL_URL should be \''._CONFIG_SITE_FULL_URL.'\'.<br/><br/>
                            Ensure the database user has privileges from your new host and that _CONFIG_DB_HOST doesn\'t say \'localhost\', it should match your database host or ip.<br/><br/>
                            In addition, edit the \'.htaccess\' file in the root to the following content: (copy &amp; paste this)<br/>
                            <pre style="line-height: 13px; font-size: 10px;">RewriteEngine On
RewriteBase <span id="rewriteBase">/</span>
RewriteRule ^(.+)\~s$ '.WEB_ROOT.'/$1~s [L]
RewriteRule ^(.+)\~i$ '.WEB_ROOT.'/$1~i [QSA,L]
RewriteCond %{REQUEST_URI} ^(.+)\~d$
RewriteRule ^(.*) delete_file.php?u=$1 [QSA,L]
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteCond $1 !\.html$
RewriteRule ^(.*) file_download.php?u=$1 [QSA,L]
RewriteRule ^(.*).html$ $1.php [QSA,L]</pre>
                            Note: Only local file storage is available for direct server uploads so ensure the directory you\'ve set above as \'server storage path\' has been created with write permissions. (chmod 755 or 777)
                        </span>
                    </div>';
$result['html'] .= '</span>';

$result['html'] .= '</form>';

echo json_encode($result);
exit;
