<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'Manage Users');
define('ADMIN_SELECTED_PAGE', 'users');

// includes and security
include_once('_local_auth.inc.php');

// page header
include_once('_header.inc.php');

// account types
$accountTypeDetails = array('free user','paid user','admin');

// account status
$accountStatusDetails = array('active','pending','disabled','suspended');

// error/success messages
if (isset($_REQUEST['sa']))
{
    adminFunctions::setSuccess('New user successfully added.');
}
elseif (isset($_REQUEST['se']))
{
    adminFunctions::setSuccess('User successfully updated.');
}
elseif (isset($_REQUEST['error']))
{
    adminFunctions::setError(urldecode($_REQUEST['error']));
}

// get any params
$filterByAccountType = '';
if(isset($_REQUEST['filterByAccountType']))
{
    $filterByAccountType = trim($_REQUEST['filterByAccountType']);
}

$filterByAccountStatus = 'active';
if(isset($_REQUEST['filterByAccountStatus']))
{
    $filterByAccountStatus = trim($_REQUEST['filterByAccountStatus']);
}
?>

<script>
    oTable = null;
    gUserId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/user_manage.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 1, "asc" ]],
            "aoColumns" : [
                { bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center" },
                { sName: 'username' },
                { sName: 'email_address' },
                { sName: 'account_type', sWidth: '10%', sClass: "center" },
                { sName: 'last_login', sWidth: '15%', sClass: "center" },
                { sName: 'space_used', sWidth: '9%', sClass: "center" },
                { sName: 'total_files', sWidth: '8%', sClass: "center" },
                { sName: 'status', sWidth: '10%', sClass: "center" },
                { bSortable: false, sWidth: '15%', sClass: "center" }
            ],
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                aoData.push( { "name": "filterByAccountType", "value": $('#filterByAccountType').val() } );
                aoData.push( { "name": "filterByAccountStatus", "value": $('#filterByAccountStatus').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "ajax/user_manage.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            }
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
        
        // dialog box
        $( "#confirmDelete" ).dialog({
            modal: true,
            autoOpen: false,
            width: 450,
            buttons: {
                "Delete User": function() {
                    removeUser();
                    $("#confirmDelete").dialog("close");
                },
                "Cancel": function() {
                    $("#confirmDelete").dialog("close");
                }
            },
            open: function() {
                resetOverlays();
            }
        });
    });

    function reloadTable()
    {
        oTable.fnDraw(false);
    }
    
    function confirmRemoveUser(userId)
    {
        $('#confirmDelete').dialog('open');
        gUserId = userId;
    }
    
    function removeFile()
    {
        $.ajax({
            type: "POST",
            url: "ajax/update_user_state.ajax.php",
            data: { fileId: gUserId, statusId: 3 },
            dataType: 'json',
            success: function(json) {
                if(json.error == true)
                {
                    showError(json.msg);
                }
                else
                {
                    showSuccess(json.msg);
                    reloadTable();
                }
                
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                showError(XMLHttpRequest.responseText);
            }
        });
    }
</script>

<div class="row clearfix">
    <div class="sectionLargeIcon largeUserIcon"></div>
    <div class="widget clearfix">
        <h2>User List</h2>
        <div class="widget_inside">
            <?php echo adminFunctions::compileNotifications(); ?>
            <div class="col_12">
                <table id='fileTable' class='dataTable'>
                    <thead>
                        <tr>
                            <th></th>
                            <th class="align-left"><?php echo adminFunctions::t('username', 'Username'); ?></th>
                            <th><?php echo adminFunctions::t('email_address', 'Email Address'); ?></th>
                            <th><?php echo adminFunctions::t('type', 'Type'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('last_login', 'Last Login'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('space_used', 'HD Used'); ?></th>
                            <th><?php echo adminFunctions::t('files', 'Files'); ?></th>
                            <th><?php echo adminFunctions::t('status', 'Status'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('actions', 'Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
            <form action="user_add.php" method="GET">
                <input type="submit" value="Add User" class="button blue"/>
            </form>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        Filter Results:
        <input name="filterText" id="filterText" type="text" onKeyUp="reloadTable(); return false;" style="width: 160px;"/>
    </label>
    <label style="padding-left: 6px;">
        By Type:
        <select name="filterByAccountType" id="filterByAccountType" onChange="reloadTable(); return false;" style="width: 160px;">
            <option value="">- all -</option>
            <?php
            if (COUNT($accountTypeDetails))
            {
                foreach ($accountTypeDetails AS $accountTypeDetail)
                {
                    echo '<option value="' . $accountTypeDetail . '"';
                    if (($filterByAccountType) && ($filterByAccountType == $accountTypeDetail))
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . UCWords($accountTypeDetail) . '</option>';
                }
            }
            ?>
        </select>
    </label>
    <label style="padding-left: 6px;">
        By Status:
        <select name="filterByAccountStatus" id="filterByAccountStatus" onChange="reloadTable(); return false;" style="width: 120px;">
            <option value="">- all -</option>
            <?php
            if (COUNT($accountStatusDetails))
            {
                foreach ($accountStatusDetails AS $accountStatusDetail)
                {
                    echo '<option value="' . $accountStatusDetail . '"';
                    if (($filterByAccountStatus) && ($filterByAccountStatus == $accountStatusDetail))
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . UCWords($accountStatusDetail) . '</option>';
                }
            }
            ?>
        </select>
    </label>
</div>

<div id="confirmDelete" title="Confirm Action">
    <p>Are you sure you want to disable this user?</p>
</div>

<?php
include_once('_footer.inc.php');
?>