<?php

require_once('includes/master.inc.php');

// clear any expired download trackers
downloadTracker::clearTimedOutDownloads();
downloadTracker::purgeDownloadData();

// try to load the file object
$file = null;
if (isset($_REQUEST['u']))
{
    // only keep the initial part if there's a forward slash
    $shortUrl = current(explode("/", $_REQUEST['u']));
    $file     = file::loadByShortUrl($shortUrl);
}

// could not load the file
if (!$file)
{
    output404();
    //redirect(getCoreSitePath() . "/index." . SITE_CONFIG_PAGE_EXTENSION);
}

/* setup page */
define("PAGE_NAME", $file->originalFilename);
define("PAGE_DESCRIPTION", t("file_download_description", "Download file"));
define("PAGE_KEYWORDS", t("file_download_keywords", "download, file, upload, mp3, avi, zip"));

// has the file been removed
if ($file->statusId == 2)
{
    $errorMsg = t("error_file_has_been_removed_by_user", "File has been removed.");
    redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
}
elseif ($file->statusId == 3)
{
    $errorMsg = t("error_file_has_been_removed_by_admin", "File has been removed by the site administrator.");
    redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
}
if ($file->statusId == 4)
{
    $errorMsg = t("error_file_has_been_removed_due_to_copyright", "File has been removed due to copyright issues.");
    redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
}

// include any plugin includes
pluginHelper::includeAppends('file_download_top.php');

// should we skip the countdown timer?
$skipCountdown = false;
if ((!isset($_SESSION['showDownload'])) || ($_SESSION['showDownload'] == null))
{
    $_SESSION['showDownload'] = time();
}

// if the user is not logged in but we have http username/password. (for download managers)
if ($Auth->loggedIn() === false)
{
    if ((isset($_SERVER['PHP_AUTH_USER'])) && (isset($_SERVER['PHP_AUTH_PW'])))
    {
        $Auth->attemptLogin(trim($_SERVER['PHP_AUTH_USER']), MD5(trim($_SERVER['PHP_AUTH_PW'])), false);
        if ($Auth->loggedIn() === false)
        {
            header('WWW-Authenticate: Basic realm="Please enter a valid username and password"');
            header('HTTP/1.0 401 Unauthorized');
            header('status: 401 Unauthorized');
            exit;
        }
    }
}

// whether to allow downloads or not if the user is not logged in
if ((!$Auth->loggedIn()) && (SITE_CONFIG_REQUIRE_USER_ACCOUNT_DOWNLOAD == 'yes'))
{
    redirect(getCoreSitePath() . "/register." . SITE_CONFIG_PAGE_EXTENSION);
}

// if we need to request the password
if(strlen($file->accessPassword) && (($Auth->id != $file->userId) || ($Auth->id == '')))
{
    if(!isset($_SESSION['allowAccess'.$file->id]))
    {
        $_SESSION['allowAccess'.$file->id] = false;
    }

    // make sure they've not already set it
    if($_SESSION['allowAccess'.$file->id] === false)
    {
        redirect(getCoreSitePath() . "/file_password." . SITE_CONFIG_PAGE_EXTENSION.'?file='.$shortUrl);
    }
}

// if logged in
if ($Auth->loggedIn() === true)
{
    // if the current logged in user is a paid subscriber or admin
    if (in_array($Auth->level, array('paid user', 'admin')))
    {
        $skipCountdown = true;
    }
}
else
{
    if (!isset($_REQUEST['d']))
    {
        $_SESSION['showDownload'] = time();
    }
}

// free or non logged in users
if (($Auth->loggedIn() === false) || ($Auth->level == 'free user'))
{
    // make sure the user is permitted to download files of this size
    if ((int) SITE_CONFIG_FREE_USER_MAX_DOWNLOAD_FILESIZE > 0)
    {
        if ((int) SITE_CONFIG_FREE_USER_MAX_DOWNLOAD_FILESIZE < $file->fileSize)
        {
            $errorMsg = t("error_you_must_register_for_a_premium_account_for_filesize", "You must register for a premium account to download files of this size. Please use the links above to register or login.");
            redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
        }
    }

    // check if the user has reached the max permitted concurrent downloads
    if ((int) SITE_CONFIG_FREE_USER_MAX_DOWNLOAD_THREADS > 0)
    {
        $sQL          = "SELECT COUNT(download_tracker.id) AS total_threads ";
        $sQL .= "FROM download_tracker ";
        $sQL .= "WHERE download_tracker.status='downloading' AND download_tracker.ip_address = " . $db->quote(getUsersIPAddress()) . " ";
        $sQL .= "GROUP BY download_tracker.ip_address ";
        $totalThreads = (int) $db->getValue($sQL);
        if ($totalThreads >= (int) SITE_CONFIG_FREE_USER_MAX_DOWNLOAD_THREADS)
        {
            $errorMsg = t("error_you_have_reached_the_max_permitted_downloads", "You have reached the maximum concurrent downloads. Please wait for your existing downloads to complete or register for a premium account above.");
            redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
        }
    }

    // make sure the user is permitted to download
    if((int) SITE_CONFIG_FREE_USER_WAIT_BETWEEN_DOWNLOADS > 0)
    {
        $sQL  = "SELECT (UNIX_TIMESTAMP()-UNIX_TIMESTAMP(date_updated)) AS seconds ";
        $sQL .= "FROM download_tracker ";
        $sQL .= "WHERE download_tracker.status='finished' AND download_tracker.ip_address = " . $db->quote(getUsersIPAddress()) . " ";
        $sQL .= "ORDER BY download_tracker.date_updated DESC ";
        $longAgoSeconds = (int) $db->getValue($sQL);
        if(($longAgoSeconds > 0) && ($longAgoSeconds < (int) SITE_CONFIG_FREE_USER_WAIT_BETWEEN_DOWNLOADS))
        {
            $errorMsg = t("error_you_must_wait_between_downloads", "You must wait [[[WAITING_TIME_LABEL]]] between downloads. Please try again later or register for a premium account above to remove the restriction.", array('WAITING_TIME_LABEL'=>secsToHumanReadable(SITE_CONFIG_FREE_USER_WAIT_BETWEEN_DOWNLOADS)));
            redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
        }
    }
}

// if SITE_CONFIG_REDIRECT_DELAY_SECONDS is zero
if ((int) SITE_CONFIG_REDIRECT_DELAY_SECONDS == 0)
{
    $skipCountdown = true;
}

// show the delayed redirect/upgrade page
if ($skipCountdown == false)
{
    // check whether we need to display the countdown timer
    if ($_SESSION['showDownload'] >= (time() - (SITE_CONFIG_REDIRECT_DELAY_SECONDS - 2)))
    {
        include_once(_CONFIG_SCRIPT_ROOT . '/delayedRedirect.php');
        exit();
    }
}

// do we need to display the captcha?
if (($Auth->loggedIn() === false) || ($Auth->level == 'free user'))
{
    if (useCaptcha() == true)
    {
        /* do we require captcha validation? */
        $showCaptcha = false;
        if (!isset($_REQUEST['recaptcha_response_field']))
        {
            $showCaptcha = true;
        }

        /* check captcha */
        if (isset($_REQUEST['recaptcha_response_field']))
        {
            $resp = recaptcha_check_answer(SITE_CONFIG_CAPTCHA_PRIVATE_KEY, $_SERVER["REMOTE_ADDR"], $_POST["recaptcha_challenge_field"], $_POST["recaptcha_response_field"]);
            if (!$resp->is_valid)
            {
                setError(t("invalid_captcha", "Captcha confirmation text is invalid."));
                $showCaptcha = true;
            }
        }

        if ($showCaptcha == true)
        {
            include_once(_CONFIG_SCRIPT_ROOT . '/fileDownloadCaptcha.inc.php');
            exit();
        }
    }
}

// include any plugin includes
pluginHelper::includeAppends('file_download_bottom.php');

// close database so we don't cause locks during the download
$db = Database::getDatabase();
$db->close();

// download file
$rs = $file->download();
if (!$rs)
{
    $errorMsg = t("error_can_not_locate_file", "File can not be located, please try again later.");
    if ($file->errorMsg != null)
    {
        $errorMsg = 'Error: ' . $file->errorMsg;
    }
    redirect(getCoreSitePath() . "/error." . SITE_CONFIG_PAGE_EXTENSION . "?e=" . urlencode($errorMsg));
}
