<?php

/**
 * main translate class
 */
class translate
{
    /* setup the initial translation constants */

    static function setUpTranslationConstants()
    {
        if (!defined("SITE_CONFIG_SITE_LANGUAGE"))
        {
            define("SITE_CONFIG_SITE_LANGUAGE", "English (en)");
        }

        $language = SITE_CONFIG_SITE_LANGUAGE;
        if (isset($_SESSION['_t']))
        {
            $language = $_SESSION['_t'];
        }

        $db         = Database::getDatabase();
        $languageId = $db->getValue("SELECT id FROM language WHERE languageName = " . $db->quote($language));
        if (!(int) $languageId)
        {
            return false;
        }

        translate::updateAllLanguageContent($languageId);

        /* load in the content */
        $rows = $db->getRows("SELECT language_key.languageKey, language_content.content FROM language_content LEFT JOIN language_key ON language_content.languageKeyId = language_key.id WHERE language_content.languageId = " . (int) $languageId);
        if (COUNT($rows))
        {
            foreach ($rows AS $row)
            {
                $constantName = "LANGUAGE_" . strtoupper($row['languageKey']);
                define($constantName, $row['content']);
            }
        }
    }

    /* translation function for JS */

    static function generateJSLanguageCode()
    {
        if (!defined("SITE_CONFIG_SITE_LANGUAGE"))
        {
            define("SITE_CONFIG_SITE_LANGUAGE", "English (en)");
        }

        $language = SITE_CONFIG_SITE_LANGUAGE;
        if (isset($_SESSION['_t']))
        {
            $language = $_SESSION['_t'];
        }

        $db         = Database::getDatabase();
        $languageId = $db->getValue("SELECT id FROM language WHERE languageName = " . $db->quote($language));
        if (!(int) $languageId)
        {
            return false;
        }

        /* setup js */
        $js   = array();
        $js[] = "/* translation function */";
        $js[] = "function t(key){ ";
        $js[] = "l = {";

        /* load in the content */
        $rows = $db->getRows("SELECT language_key.languageKey, language_content.content FROM language_content LEFT JOIN language_key ON language_content.languageKeyId = language_key.id WHERE language_content.languageId = " . (int) $languageId);
        if (COUNT($rows))
        {
            $ljs = array();
            foreach ($rows AS $row)
            {
                $ljs[] = "\"" . addslashes($row['languageKey']) . "\":\"" . addslashes(str_replace(array("\r", "\n"), "", self::getTranslation($row['languageKey']))) . "\"";
            }
            $js[] = implode(", ", $ljs);
        }
        $js[] = "};";

        $js[] = "return l[key.toLowerCase()];";
        $js[] = "}";
        return implode("\n", $js);
    }

    static function updateAllLanguageContent($languageId)
    {
        $db             = Database::getDatabase();
        /* make sure we have all content records populated */
        $getMissingRows = $db->getRows("SELECT id, languageKey, defaultContent FROM language_key WHERE id NOT IN (SELECT languageKeyId FROM language_content WHERE languageId = " . (int) $languageId . ")");
        if (is_array($getMissingRows) && COUNT($getMissingRows))
        {
            foreach ($getMissingRows AS $getMissingRow)
            {
                $dbInsert                = new DBObject("language_content", array("languageKeyId", "languageId", "content"));
                $dbInsert->languageKeyId = $getMissingRow['id'];
                $dbInsert->languageId    = (int) $languageId;
                $dbInsert->content       = $getMissingRow['defaultContent'];
                $dbInsert->insert();
            }
        }
    }

    static function getTranslation($key, $defaultContent = '', $isAdminArea = 0, $replacements = array())
    {
        /* are we in language debug mode */
        if (SITE_CONFIG_LANGUAGE_SHOW_KEY == "key")
        {
            return strlen($defaultContent) ? $defaultContent : $key;
        }

        /* return the language translation if we can find it */
        $constantName = "LANGUAGE_" . strtoupper($key);
        if (!defined($constantName))
        {
            if (strlen($defaultContent))
            {
                $language = SITE_CONFIG_SITE_LANGUAGE;
                if (isset($_SESSION['_t']))
                {
                    $language = $_SESSION['_t'];
                }

                $db         = Database::getDatabase();
                $languageId = $db->getValue("SELECT id FROM language WHERE languageName = " . $db->quote($language));
                if (!(int) $languageId)
                {
                    return false;
                }

                // insert default key value
                $dbInsert                 = new DBObject("language_key", array("languageKey", "defaultContent", "isAdminArea"));
                $dbInsert->languageKey    = $key;
                $dbInsert->defaultContent = $defaultContent;
                $dbInsert->isAdminArea    = (int) $isAdminArea;
                $dbInsert->insert();

                // set constant
                define("LANGUAGE_" . strtoupper($key), $defaultContent);

                // do replacements
                if (COUNT($replacements))
                {
                    foreach ($replacements AS $k => $replacement)
                    {
                        $defaultContent = str_replace('[[[' . strtoupper($k) . ']]]', $replacement, $defaultContent);
                    }
                }

                return $defaultContent;
            }
            return "<font style='color:red;'>SITE ERROR: MISSING TRANSLATION *** <strong>" . $key . "</strong> ***</font>";
        }

        // do replacements
        $text = constant($constantName);
        if (COUNT($replacements))
        {
            foreach ($replacements AS $k => $replacement)
            {
                $text = str_replace('[[[' . strtoupper($k) . ']]]', $replacement, $text);
            }
        }

        return $text;
    }

}

?>