<?php

// Application flag
define('SPF', true);

// Determine our absolute document root
define('DOC_ROOT', realpath(dirname(__FILE__) . '/../'));

// Global include files
require DOC_ROOT . '/includes/functions.inc.php'; // __autoload() is contained in this file
require DOC_ROOT . '/includes/class.dbobject.php';
require DOC_ROOT . '/includes/class.objects.php';
require DOC_ROOT . '/includes/email_class/class.phpmailer.php';
require DOC_ROOT . '/includes/recaptcha/recaptchalib.php';

// Fix magic quotes
if (get_magic_quotes_gpc())
{
    $_POST    = fix_slashes($_POST);
    $_GET     = fix_slashes($_GET);
    $_REQUEST = fix_slashes($_REQUEST);
    $_COOKIE  = fix_slashes($_COOKIE);
}

// Load our config settings
$Config = Config::getConfig();

// make sure the url exactly matches the one set in _config.inc.php
checkDomain();

/* load db config settings into constants */
$db   = Database::getDatabase();
$rows = $db->getRows("SELECT config_key, config_value FROM site_config ORDER BY config_group, config_key");
if (COUNT($rows))
{
    foreach ($rows AS $row)
    {
        $constantName = "SITE_CONFIG_" . strtoupper($row['config_key']);
        if (!defined($constantName))
        {
            define($constantName, $row['config_value']);
        }
    }
}

// store session info in the database?
if ($Config->useDBSessions === true)
{
    DBSession::register();
}

// initialize our session
session_name($Config->sessionName);

// rejoin sessions, used for cors
$sessionStarted = false;
if (isset($_REQUEST['_sid']))
{
    // check we have a matching trk in the database for security purposes
    if (isset($_REQUEST['_trk']))
    {
        $isValidSession = dbsession::validateCrossSiteSession($_REQUEST['_sid'], $_REQUEST['_trk']);
        if ($isValidSession)
        {
            $sid = $_REQUEST['_sid'];
            session_id($sid);

            // get session un/pw from db
            $db->query('SELECT data FROM sessions WHERE id=:id', array('id' => $sid));
            $sessionData = $db->getValue();
            if ($sessionData)
            {
                session_start();
                $sessionStarted = true;
                
                // reapply session
                session_decode($sessionData);
            }
        }
    }
}

// start session
if ($sessionStarted == false)
{
    session_start();
}

// pick up any requests to change the site language
if (isset($_REQUEST['_t']))
{
    // make sure the one passed is an active language
    $isValidLanguage = $db->getRow("SELECT languageName, flag FROM language WHERE isActive = 1 AND languageName = '" . $db->escape(trim($_REQUEST['_t'])) . "' LIMIT 1");
    if ($isValidLanguage)
    {
        $_SESSION['_t'] = trim($_REQUEST['_t']);
    }
    else
    {
        $_SESSION['_t'] = SITE_CONFIG_SITE_LANGUAGE;
    }
}
elseif (!isset($_SESSION['_t']))
{
    $_SESSION['_t'] = SITE_CONFIG_SITE_LANGUAGE;
}

/* setup translations */
translate::setUpTranslationConstants();

// Initialize current user
$Auth = Auth::getAuth();

// Object for tracking and displaying error messages
$Error = Error::getError();

define("SITE_IMAGE_PATH", WEB_ROOT . "/themes/" . SITE_CONFIG_SITE_THEME . "/images");
define("SITE_CSS_PATH", WEB_ROOT . "/themes/" . SITE_CONFIG_SITE_THEME . "/styles");
define("SITE_JS_PATH", WEB_ROOT . "/themes/" . SITE_CONFIG_SITE_THEME . "/js");

// how often to update the download tracker in seconds.
define('DOWNLOAD_TRACKER_UPDATE_FREQUENCY', 20);

// how long to keep the download tracker data, in days
define('DOWNLOAD_TRACKER_PURGE_PERIOD', 7);

// the root plugin directory
define('PLUGIN_DIRECTORY_NAME', 'plugins');
define('PLUGIN_DIRECTORY_ROOT', DOC_ROOT . '/' . PLUGIN_DIRECTORY_NAME . '/');
define('PLUGIN_WEB_ROOT', WEB_ROOT . '/' . PLUGIN_DIRECTORY_NAME);

// admin paths
define('ADMIN_FOLDER_NAME', 'admin');
define('ADMIN_WEB_ROOT', WEB_ROOT . '/' . ADMIN_FOLDER_NAME);

/* check for banned ip */
$bannedIP = bannedIP::getBannedType();
if (strtolower($bannedIP) == "whole site")
{
    header('HTTP/1.1 404 Not Found');
    die();
}

// setup demo mode
if (_CONFIG_DEMO_MODE == true)
{
    if (isset($_REQUEST['_p']))
    {
        $_SESSION['_plugins'] = false;
        if ((int) $_REQUEST['_p'] == 1)
        {
            $_SESSION['_plugins'] = true;
        }
        unset($_SESSION['pluginConfigs']);
    }

    if (!isset($_SESSION['_plugins']))
    {
        $_SESSION['_plugins'] = true;
        unset($_SESSION['pluginConfigs']);
    }
}

// load plugin configuration into the session
if (!isset($_SESSION['pluginConfigs']))
{
    $_SESSION['pluginConfigs'] = pluginHelper::loadPluginConfigurationFiles();
}

// append any plugin includes
pluginHelper::includeAppends('master.inc.php');
