/**
 * Alert Count by Bloodcinder
 */
!function($) {
	Bloodcinder_AlertCount = {
		initialize: function() {
			Bloodcinder_AlertCount.original_title =
				Bloodcinder_AlertCount.assigned_title = $('head > title').html();
				
			if (XenForo._bc_alertcount_aggressive)
				$('head > title').bind('DOMSubtreeModified', Bloodcinder_AlertCount.sticky);
				
			$(document).bind('XFAjaxSuccess', Bloodcinder_AlertCount.update);
			
			Bloodcinder_AlertCount.update();
			Bloodcinder_AlertCount.queue();
		},
		
		update: function() {
			count = Bloodcinder_AlertCount.sum();
			if (count != Bloodcinder_AlertCount.previous_count || XenForo._bc_alertcount_aggressive) {
				Bloodcinder_AlertCount.previous_count = count;
				Bloodcinder_AlertCount.assigned_title = (count > 0 ? '(' + count + ') ' : '') + Bloodcinder_AlertCount.original_title;
				$('head > title').html(Bloodcinder_AlertCount.assigned_title);
			}
		},
		
		sum: function() {
			return (
				parseInt($("#AlertsMenu_Counter").text(), 10)
				+ parseInt($("#ConversationsMenu_Counter").text(), 10)
			) || parseInt($("#VisitorExtraMenu_Counter").text(), 10);
		},

		poll: function() {
			XenForo.ajax(
				'alertcount-refresh',
				{},
				Bloodcinder_AlertCount.queue,
				{ type: 'GET', global: false }
			);
		},
		
		queue: function() {
			if (XenForo._bc_alertcount_interval > 0)
				setTimeout(
					Bloodcinder_AlertCount.poll,
					XenForo._bc_alertcount_interval * 1000
				);
		},
		
		sticky: function() {
			if ($('head > title').html() != Bloodcinder_AlertCount.assigned_title) {
				$('head > title').unbind('DOMSubtreeModified', Bloodcinder_AlertCount.sticky);
				$('head > title').html(Bloodcinder_AlertCount.assigned_title);
				$('head > title').bind('DOMSubtreeModified', Bloodcinder_AlertCount.sticky);
			}
		}
	};
	
	$(document).ready(Bloodcinder_AlertCount.initialize);
}(jQuery);