$(document).ready(function() {
	$('#ctrl_amount').on("keyup", function() {
		triggerAction();
	});
	$('#ctrl_amount').change(function() {
		triggerAction();
	});
	$('#ctrl_currency_id').change(function(){
		triggerAction();
	});
	triggerAction();
});

function triggerAction(){
	if($('#ctrl_currency_id').val() && $('#ctrl_amount').val()>0){
		$('#ctrl_submit')
			.removeAttr('disabled')
			.removeClass('disabled')
			.trigger('DisablerDisabled');
		getForumAmount($('#ctrl_amount').val() , $('#ctrl_currency_id').val());
	}else{
		$('#ctrl_submit')
			.prop('disabled', true)
			.addClass('disabled')
			.trigger('DisablerEnabled');
	}
}
function getForumAmount($price, $currencyId){
	if($price && $currencyId){
		XenForo.ajax(
			"index.php?payment-paypal/get-forum-amount.json", 
			{
				price: $price,
				currency_id: $currencyId,
				xfToken: $('#ctrl_xfToken').val(),
			}, 
			function(json){
				if(XenForo.hasResponseError(json) !== false){				
					return true;
				}
				$('#amountMessage').html(json.amountMessage);
				$('#transactionTitle').val(json.transactionTitle);
				$('#ctrl_custom').val(json.custom);
			},
			{cache: false}
		);
	}
}