/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	/**
	 * Form that handles adding more participant groups
	 *
	 * @param jQuery #GroupForm
	 */
	XenForo.GroupForm = function($form)
	{
		var $placeholder = $('#GroupPlaceholder');

		$form.bind('AutoValidationComplete', function(e)
		{
			var $action = e.ajaxData.action;
			
			if ($action == 'insert')
			{
				$form.get(0).reset();
				
				// check that templateHtml was received from the AJAX request
				if (e.ajaxData.templateHtml)
				{
					// prevent the normal AutoValidator success message and redirect stuff
					e.preventDefault();
					
					// header
					$('div[name="group_list"]').attr('style', 'display:block;');
					
					new XenForo.ExtLoader(e.ajaxData, function()
					{
						// append the templateHtml into the groups list
						$(e.ajaxData.templateHtml).xfInsert('appendTo', $placeholder, 'xfSlideDown', XenForo.speed.normal);
					});
					
					// do we need to hide the insert new group option
					if (e.ajaxData.numGroups >= e.ajaxData.maxGroups)
					{
						$('div[name="new_group"]').attr('style', 'display:none;');
						$('div[name="max_groups"]').attr('style', 'display:block;');
					}
				}
			}
			else if ($action == 'delete')
			{
				// remove the deleted group
				$('div[name="group_item_' + e.ajaxData.id + '"]').xfRemove();
				$form.get(0).reset();
				
				if (e.ajaxData.numGroups < 1) // was last group, so hide the header
				{
					$('div[name="group_list"]').attr('style', 'display:none;');
				}
				else if (e.ajaxData.nextGroupId > 0) // is last group or was first group, so hide fieldset line
				{
					$('fieldset[id="fieldset_' + e.ajaxData.nextGroupId + '"]').attr('style', 'border:0;margin-top:0;margin-bottom:0;');
				}
								
				// do we need to display the insert new group option
				if (e.ajaxData.numGroups < e.ajaxData.maxGroups)
				{
					$('div[name="new_group"]').attr('style', 'display:block;');
					$('div[name="max_groups"]').attr('style', 'display:none;');
				}
			}
			else if ($action == 'update')
			{
				var $id = e.ajaxData.id;
				
				// hide the input box and update the group name
				$('input[name="group_name_' + $id + '"]').attr('style', 'display:none;');
				$('span[name="group_name_span_' + $id + '"]').text(e.ajaxData.groupName);
				$('span[name="group_name_span_' + $id + '"]').attr('style', 'display:block;');
				
				// hide the input box and update the usernames
				$('input[name="recipients_' + $id + '"]').attr('style', 'display:none;');
				$('span[name="recipients_span_' + $id + '"]').text(e.ajaxData.recipients);
				$('span[name="recipients_span_' + $id + '"]').attr('style', 'display:block;');
				
				// hide the save changes button and show the edit one
				$('input[name="submit_' + $id + '"]').attr('style', 'display:none;');
				$('input[name="edit_' + $id + '"]').attr('style', 'display:inline-block;');
			}
			
			// re-enable the submit button if it's been disabled
			$form.find('input').removeAttr('disabled').removeClass('disabled');
								
			// reset hidden input
			$('input[name="group_id"]').val(0);
			$('input[name="action"]').val('insert');
		});
	};

	// *********************************************************************

	XenForo.register('#GroupForm', 'XenForo.GroupForm');

}
(jQuery, this, document);