XenForo.lastPostPreviewTooltip = function($el)
{
    var hasTooltip, previewUrl, setupTimer;

    var offsetx = parseInt($el.data('offsetx'), 10) || -15;

    if (!parseInt(XenForo._enableOverlays))
    {
        return;
    }

    if (!(previewUrl = $el.data('previewurl')))
    {
        console.warn('Preview tooltip has no preview: %o', $el);
        return;
    }

    $el.find('[title]').andSelf().attr('title', '');

    $el.bind(
        {
            mouseenter: function(e)
            {
                if (hasTooltip)
                {
                    return;
                }

                setupTimer = setTimeout(function()
                {
                    if (hasTooltip)
                    {
                        return;
                    }

                    hasTooltip = true;

                    var $tipSource = $('#lastPostPreviewTooltip'),
                        $tipHtml,
                        xhr;

                    if (!$tipSource.length)
                    {
                        console.error('Unable to find #lastPostPreviewTooltip');
                        return;
                    }

                    console.log('Setup preview tooltip for %s', previewUrl);

                    $tipHtml = $tipSource.clone()
                        .removeAttr('id')
                        .addClass('xenPreviewTooltip')
                        .appendTo(document.body);

                    if (!XenForo._PreviewTooltipCache[previewUrl])
                    {
                        xhr = XenForo.ajax(
                            previewUrl,
                            {},
                            function(ajaxData)
                            {
                                if (XenForo.hasTemplateHtml(ajaxData))
                                {
                                    XenForo._PreviewTooltipCache[previewUrl] = ajaxData.templateHtml;

                                    $(ajaxData.templateHtml).xfInsert('replaceAll', $tipHtml.find('.PreviewContents'));
                                }
                                else
                                {
                                    $tipHtml.remove();
                                }
                            },
                            {
                                type: 'GET',
                                error: false,
                                global: false
                            }
                        );
                    }


                    $el.tooltip(XenForo.configureTooltipRtl({
                        predelay: 500,
                        delay: 0,
                        effect: 'PreviewTooltip',
                        fadeInSpeed: 'normal',
                        fadeOutSpeed: 'fast',
                        tip: $tipHtml,
                        position: 'bottom left',
                        offset: [ 10, offsetx ] // was 10, 25
                    }));

                    $el.data('tooltip').show(0);

                    if (XenForo._PreviewTooltipCache[previewUrl])
                    {
                        $(XenForo._PreviewTooltipCache[previewUrl])
                            .xfInsert('replaceAll', $tipHtml.find('.PreviewContents'), 'show', 0);
                    }
                }, 800);
            },

            mouseleave: function(e)
            {
                if (hasTooltip)
                {
                    if ($el.data('tooltip'))
                    {
                        	$el.data('tooltip').hide();
                    }

                    return;
                }

                if (setupTimer)
                {
                    	clearTimeout(setupTimer);
                }
            },

            mousedown: function(e)
            {
                // the click will cancel a timer or hide the tooltip
                if (setupTimer)
                {
                    clearTimeout(setupTimer);
                }

                if ($el.data('tooltip'))
                {
                    	$el.data('tooltip').hide();
                }
            }
        });
};


if (!XenForo.isTouchBrowser())
{
    XenForo.register('.lastPostPreviewTooltip', 'XenForo.lastPostPreviewTooltip');
}