/**
* www.rellect.com
*/

XenForo.rellect = XenForo.rellect || {};

!function($, window, document, _undefined)
{
	XenForo.rellect.AdblockDetector = function() { this.__construct(); };
	XenForo.rellect.AdblockDetector.prototype = {
		__construct: function(){
			/**
			 * If the required params are not found, stop the script
			 */
			if(typeof XenForo.rellect.AdblockDetectorParams === 'undefined')
				return;

			/**
			 * Save 'this' context globally
			 */
			$AdblockDetector = this;

			/**
			 * Build the test script
			 */
			var script = $('<script />', {
				async: 'async',
				/**
				 * Load a google script if adblock white-listed the domain
				 * Load local script for any other site
				 */
				src: (XenForo.rellect.AdblockDetectorParams.whitelisted) ? 
					'//pagead2.googlesyndication.com/pagead/show_ads.js' : 
					_bH+'js/rellect/AdblockDetector/advertisement.js?v=1.1.0'
			}).on('load', function(){
				/**
				 * Script is loaded - adblock wasn't detected
				 */
				$AdblockDetector.tracking('No AdBlock');

			}).on('error', function(e){
				/**
				 * The script failed to load, we assume adblocker blocked it.
				 * TODO: make sure it's not failed because of time-out
				 */
				if(XenForo.rellect.AdblockDetectorParams !== undefined)
				{
					$AdblockDetector.alert(XenForo.rellect.AdblockDetectorParams.type);
				}

				/**
				 * Callback the tracking function with the result
				 */
				$AdblockDetector.tracking('AdBlock Enabled');
			});
			/**
			 * This line actually execute the script loading
			 */
			$('head')[0].appendChild(script[0]);
		},

		/**
		 * Set cookie for pre-defined time
		 */
		setCookie: function(){
			var expiry = new Date();
			expiry.setTime(expiry.getTime() + (XenForo.rellect.AdblockDetectorParams.expiry * 1000)); /* milliseconds value */
			$.setCookie('adblock_alert', XenForo.rellect.AdblockDetectorParams.hours, expiry);
		},

		tracking: function(action){
			/**
			* This will be written in the future for tracking use
			*/
		},

		/**
		 * This is function is used to handle the dismiss action
		 */
		dismissed: function(){
			/**
			 * Callback the tracking function with the result
			 */
			$AdblockDetector.tracking('Alert Dismissed');

			/**
			 * If 'hours' value is -1, no cookie is needed as the alert will always be shown
			 */
			if(XenForo.rellect.AdblockDetectorParams.hours != '-1')
				$AdblockDetector.setCookie();
		},

		/**
		 * Handle the alert types
		 */
		alert: function(type){
			/**
			 * Title and message for the alert
			 */
			title = String(XenForo.rellect.AdblockDetectorParams.phrases.title || 'Missing phrase');
			message = String(XenForo.rellect.AdblockDetectorParams.phrases.message || 'Missing phrase');

			switch(type){

				/**
				 * XenForo Notice
				 */
				case 'notice':
				{
					/**
					 * The notice html is already exists in the page (added by TMS)
					 * It is just hidden, so we only need to show it now
					 */
					$('.adblock_notice').show();

					/**
					 * Close action, with animation
					 */
					$('.adblock_notice').find('.close').click(function(){
						/**
						 * Hide the alert
						 */
						$('.adblock_notice').slideUp(300);

						/**
						 * Trigger the dismiss function
						 */
						$AdblockDetector.dismissed();
					});

				}
				break;

				/**
				 * Floating Message
				 */
				case 'float':
				{
					/**
					 * Build the html
					 */
					$alert = $(''
						+ '<div class="adblock_detector adblock_floating_message" style="display:none">'
						+ 	'<div class="errorDetails">'
						+ 		'<div class="alertIcon"></div>'
						+ 		'<a class="close Tooltip" data-tipclass="upsidedown flipped" data-position="bottom left" data-offsety="6" title="'+XenForo.rellect.AdblockDetectorParams.phrases.close+'">&#10006;</a>'
						+ 		'<div class="errorMessage">'+message+'</div>'
						+ 	'</div>'
						+ '</div>'
					);

					/**
					 * If user can't dismiss, remove the dismiss link from the alert
					 */
					if(!XenForo.rellect.AdblockDetectorParams.canDismiss)
					{
						$alert.find('.close').css('display', 'none');
					}

					/**
					 * This is needed for touch devices as 'fixed' position could lead to inconvenience
					 */
					if (XenForo.isTouchBrowser())
					{
						$alert.css('position', 'absolute');
					}

					/**
					 * Insert the alert into the dom
					 */
					var alertHolder = $alert.prependTo("body"),
						alertHeight = alertHolder.height(),
						$html = $('html');

					/**
					 * Activate the tooltip
					 */
					alertHolder.xfActivate();

					/**
					 * It is safe to show the alert now
					 */
					alertHolder.show();
	
					/**
					 * Create space in the top of the page to contain the alert
					 */
					$html.css('padding-top', alertHeight);

					$(window).on('resize orientationchange', function(e){
						/**
						 * If the alert height is the same, no need to continue with this function
						 */
						if (alertHeight == alertHolder.height())
							return;

						/**
						 * Update the space in the top of the page to contain the alert, as it may change on resize
						 */
						alertHeight = alertHolder.height();
						$html.css('padding-top', alertHeight);
					});

					/**
					 * Close action, with animation
					 */
					alertHolder.find('.close').click(function(){
						/**
						 * Hide the alert
						 */
						$('.adblock_detector').slideUp(300);

						/*
						 * Remove the space in the top of the page that was added previously
						 */
						$html.animate({
							paddingTop: 0
						}, 300);

						/**
						 * Trigger the dismiss function
						 */
						$AdblockDetector.dismissed();
					});
				}
				break;

				/**
				 * Overlay
				 */
				case 'overlay':
				{
					/**
					 * Build the html
					 */
					var $alert = $(''
						+ '<div class="errorOverlay">'
						+ 	'<a class="close OverlayCloser"></a>'
						+ 	'<h2 class="heading">' + title + '</h2>'
						+ 	'<div class="baseHtml errorDetails">'+ message +'</div>'
						+ '</div>'
					);

					/**
					 * If user can't dismiss, remove the dismiss link from the alert
					 */
					if(!XenForo.rellect.AdblockDetectorParams.canDismiss)
					{
						$alert.find('.OverlayCloser').css('display', 'none');
					}

					/**
					 * Build the overlay
					 */
					XenForo.createOverlay(null, $alert, {
						onBeforeClose: function()
						{
							/**
							 * Disallow to dismiss if this is not allowed for the user
							 */
							if(!XenForo.rellect.AdblockDetectorParams.canDismiss)
								return false;

							/**
							 * Trigger the dismiss function
							 */
							$AdblockDetector.dismissed();
						}
					}).load();
				}
				break;
			}
		}
	};

	XenForo.create('XenForo.rellect.AdblockDetector', this);
}
(jQuery, this, document);