/**
* www.rellect.com
*/

XenForo.rellect = XenForo.rellect || {};
XenForo.rellect.ResponsiveAdmin = XenForo.rellect.ResponsiveAdmin || {};

!function($, window, document, _undefined)
{
	$.extend(XenForo.rellect.ResponsiveAdmin,{
		/**
		* Responsive tabs
		* - When there's not enough space, the links will go into a menu
		*/
		UpdateAcpTabs: function()
		{
			var $tabs = $('#tabsNav .acpTabs');
			if(!$tabs.length){
				return;
			}

			var	tabsCoords = $tabs.coords(),
				$publicInnerTabs = $tabs.find('> li:not(.separated):not(#openSideNav)'),
				$visitorInnerTabs = $tabs.find('> li.separated'),
				maxPublicWidth,
				$hiddenTab = $publicInnerTabs.filter('.navigationHiddenTabs');

			$publicInnerTabs.show();
			$hiddenTab.hide();

			$visitorInnerTabs.show();

			maxPublicWidth = $publicInnerTabs.width() - $visitorInnerTabs.width();

			var hidePublicTabs = function(){
				var shownSel = '.active, .navigationHiddenTabs';

				var $hideable = $publicInnerTabs.filter(':not(' + shownSel + ')'),
					$hiddenList = $('<ul />'),
					hiddenCount = 0,
					overflowMenuShown = false;

				$.each($hideable.get().reverse(), function(){
					var $this = $(this);
					if(isOverflowing(true)){
						$hiddenList.prepend(
							$('<li />').html($this.find('a').clone())
						);
						$this.hide();
						hiddenCount++;
					}
					else{
						if(hiddenCount){
							$hiddenTab.show();

							if(isOverflowing(true)){
								$hiddenList.prepend(
									$('<li />').html($this.find('a').clone())
								);
								$this.hide();
								hiddenCount++;
							}
							$('#NavigationHiddenMenu').html($hiddenList); //.xfActivate();
							overflowMenuShown = true;
						}
						else{
							$hiddenTab.hide();
						}

						return false;
					}
				});

				if(hiddenCount && !overflowMenuShown){
					$hiddenTab.show();
					$('#NavigationHiddenMenu').html($hiddenList); //.xfActivate();
				}
			},
			isOverflowing = function(checkMax){
				var coords = $('.acpTabs .separated').last().coords();
				if(
					coords.top >= tabsCoords.top + tabsCoords.height
					|| coords.height >= tabsCoords.height * 2
				){
					return true;
				}

				return false;
			};

			if(isOverflowing()){
				hidePublicTabs();
			}
		}
	});
	$(function()
	{
		$('.navigationHiddenTabsTabs').click(function(e){
			e.stopPropagation();
		});

		var htmlWidth = $('.apcTabs').width(), sideNav = $('#sideNav');
		$(window).on('resize orientationchange load', function(e){
			if(e.type != 'load' && $('html').width() == htmlWidth){
				return;
			}

			htmlWidth = $('.apcTabs').width();

			XenForo.rellect.ResponsiveAdmin.UpdateAcpTabs();

			// Hide open link if sidenav is empty
			if(e.type == 'load' && sideNav.find('> li').length == 1){
				$('#openSideNav').css('cssText', 'display: none !important;'); // css('display', x) doesn't accept !important
			}
		});

		/**
		* SideNav
		* - toggle button
		*/
		sideNav.append('<li id="hideSideNav"><a href="javascript:void">X</a></li>');
		sideNav.addClass('blockImportant').insertBefore('#contentContainer');
		$('#openSideNav, #hideSideNav').click(function(e){
			e.preventDefault();
			e.stopPropagation();

			var sideNav = $('#sideNav');
			if(sideNav.is(":visible")){
				sideNav.slideToggle(400, function(){ sideNav.addClass('blockImportant'); });
			}
			else{
				sideNav.removeClass('blockImportant').hide().slideToggle();
			}

			if(this.id == 'openSideNav'){
				$(this).toggleClass('arrowUp');
			}
		});

		/**
		* Hide keyboard on submission in the login page (mostly for iOS)
		* Required for the logo zoom-out effect
		*/
		$('form.AcpLoginForm').submit(function(e){
			$(document.activeElement).blur();
			setTimeout(function(){window.scrollTo(0,0)}, 0);
		});

		/**
		* Jump to top button
		*/
		if(XenForo.isTouchBrowser()){
			var jumpTop = $('<a class="adminJumpTop" href="javascript:void()" style="display:none">▲</a>').appendTo('body');
			jumpTop.click(function(e){
				e.preventDefault();
				$("body").animate({ scrollTop: 0 }, 500);
			});
			$(window).scroll(function(){
				if($(this).scrollTop() > 300){
					jumpTop.show();
				}
				else{
					jumpTop.hide();
				}
			});
		}

		/**
		* Correct background-position for .subHeading if it has filter
		* Needed for the out-of-div position trick
		* Note: only helps when the height is one line, when it breaks to multiple lines looks weird
		*       not sure it there is much to do about it, rare case anyway
		*/
		$('.subHeading .FilterControls').parent().css('background-position', 'bottom');
	});

	/**
	* Some tooltips are opened onclick in touch devices, instead of doing the real click
	* This function will delete those tooltips
	*/
	if(XenForo.isTouchBrowser()){
		XenForo.StylePropertyTooltip = function(){};
	}
}
(jQuery, this, document);