var robodn = robodn || {};

/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	robodn.ProgressTextColour = function($handle)
	{
		var $w1 = $('.progressText', $handle),
			$w2 = $('.progressGraphic', $handle),
			percent = $w1.html(),
			totalWidth = $handle.width();

		if (totalWidth == parseInt($w2.css('width')))
		{
			return;
		}

		$w2.css('marginTop', 0).width($w2.width());
		$w2.html('<span style="width: ' + totalWidth + 'px; text-align: center; display: block;">' + percent + '</span>');
		$span2 = $('span', $w2);

		$w1.css('float', 'right').width(totalWidth - $w2.width());
		$w1.html('<span style="width: ' + totalWidth + 'px; text-align: center; float: right; display: block; margin-left: ' + -totalWidth / 2 + 'px">' + percent + '</span>');
		$span1 = $('span', $w1);

		$(window).resize(function(){
			var totalWidth = $handle.width();

			/*
			 This line looks hacky so I best explain it...
			 What happens is we set the percent width to get the width relative to the parents width, easily done with CSS instead of JS.
			 Then we have the width(width()) simply rounds the width to a pixel since everything else is relative to that.
			*/
			$w2.css('width', percent).width($w2.width());
			$w1.width(totalWidth - $w2.width());
			$span1.width(totalWidth);

			$span2.width(totalWidth);
		});
	}

	robodn.ShowDonateForm = function($handle) { this.__construct($handle); };
	robodn.ShowDonateForm.prototype =
	{
		__construct: function($handle)
		{
			this.$handle = $handle.click($.context(this, 'show'));

			this.$container = $('.DonateFormContainer');
		},

		show: function()
		{
			$('.HideOnAction').parent().hide();

			this.$container.xfFadeDown(XenForo.speed.slow, function()
			{
				$(this).find('input, select, textarea, button').get(0).focus();
			});

			return false;
		}
	};

	robodn.SubmitDonateForm = function($form)
	{
		var that = this;

		this.$form = $form;
		this.$donateButton = $form.find('.donateButton .inner');
		this.processingText = this.$donateButton.data('processingText');
		this.donateText = this.$donateButton.val();

		$form.bind(
		{
			AutoValidationBeforeSubmit: function(e)
			{
				that.$donateButton.val(that.processingText).attr('disabled', 'disabled');
				that.$donateButton.parent().addClass('processing');
			},

			AutoValidationComplete: function(e)
			{
				new XenForo.ExtLoader(e.ajaxData, function()
				{
					$(e.ajaxData.templateHtml).each(function()
					{
						if (this.tagName)
						{
							var newForm = this;
							that.$form.xfFadeOut(XenForo.speed.xxfast, function()
							{
								$(newForm).xfInsert('appendTo', that.$form.parent(), 'xfFadeIn');
							});
						}
					});
				});

				return false;
			},

			AutoValidationError: function(e)
			{
				that.$donateButton.val(that.donateText).removeAttr('disabled');
				that.$donateButton.parent().removeClass('processing');
			}
		});
	};

	robodn.DonationListOptions = function($handle) { this.__construct($handle); };
	robodn.DonationListOptions.prototype =
	{
		__construct: function($handle)
		{
			this.$handle = $handle.click($.context(this, 'toggleOptions'));

			this.$options = $('form.DonationListOptions').hide();

			this.$submit = $('input:submit', this.$options).click($.context(this, 'hideOptions'));
			this.$reset = $('input:reset', this.$options).click($.context(this, 'hideOptions'));
		},

		toggleOptions: function(e)
		{
			if (this.$options.is(':animated'))
			{
				return false;
			}

			if (this.$options.is(':hidden'))
			{
				this.showOptions();
			}
			else
			{
				this.hideOptions();
			}

			return false;
		},

		showOptions: function()
		{
			this.$options.xfSlideDown(XenForo.speed.fast, function()
			{
				$(this).find('input, select, textarea, button').get(0).focus();
			});
		},

		hideOptions: function()
		{
			this.$options.xfSlideUp(XenForo.speed.fast);
		}
	}

	robodn.AmountControl = function($handle)
	{
		var $openAmount = $('input.OpenAmount');

		$handle.bind('change', function()
		{
			if ($openAmount)
			{
				$openAmount.val($handle.find('option:selected').val());
			}
		});

		if ($openAmount)
		{
			$openAmount.bind('change', function()
			{
				$handle.val(0);
			});
		}
	}


	robodn.DatePreset = function($handle) { this.__construct($handle); };
	robodn.DatePreset.prototype =
	{
		__construct: function($handle)
		{
			this.$anchor = $handle.find('a');
			this.$anchor.click($.context(this, 'click'));
		},

		click: function(e)
		{
			var presets = $(e.currentTarget).data('preset');
			presets = presets.split(',');

			if (typeof presets[0] !== 'undefined' && presets[0] != '')
			{
				this.setStartDate(presets[0]);
			}

			if (typeof presets[1] !== 'undefined' && presets[1] != '')
			{
				this.setEndDate(presets[1]);
			}

			if (typeof presets[2] !== 'undefined')
			{
				this.setRecurring(presets[2]);
			}

			$('.PopupOpen').click();

			e.preventDefault();
		},

		/*
			[now|start][+|-][#][day|month|year]
			now can be set alone for the time now
			start can be with +0 to do the start of the day/month/year
			now+1month would be the time now plus a month
			start+1months would be the 1st of this month plus 1 month
			So to do monthly starting this month you would do...
				start+0month for the start and start+1month for the end...
				with how this is setup it would be "start+0month,start+1month,1"
		 */
		formatStringToDate: function(string)
		{
			var date = new Date();

			if (string == 'clear')
			{
				return ['', '00', '00'];
			}

			if (string != 'now')
			{
				// find start or now and remove it from the parsed string
				var start;
				start = string.indexOf('start') === 0;
				if (string.indexOf('startdate') === 0)
				{
					// Get the start date and set 'date' to it
					var startDate = $('.StartDate').val(),
						startHour = $('.StartHour').val(),
						startMinute = $('.StartMinute').val();

					startDate = startDate.split('-');
					date.setMinutes(startMinute);
					date.setSeconds(0);
					date.setHours(startHour);
					date.setFullYear(startDate[0]);
					date.setMonth(startDate[1] - 1);
					date.setDate(startDate[2]);

					string = string.substr(9);
					start = false;
				}
				else if (start)
				{
					string = string.substr(5);
				}
				else
				{
					if (string.indexOf('now') === -1)
					{
						return false;
					}

					string = string.substr(3);
				}

				// Now find + or - and remove it
				var plus = string.indexOf('+') === 0;
				if (!plus)
				{
					if (string.indexOf('-') !== 0)
					{
						return false;
					}
				}
				string = string.substr(1);

				// Now grab the day/month/year
				var unit, i;
				if ((i = string.indexOf('day')) !== -1)
				{
					unit = 'day';
				}
				else if ((i = string.indexOf('month')) !== -1)
				{
					unit = 'month';
				}
				else if ((i = string.indexOf('year')) !== -1)
				{
					unit = 'year';
				}
				else
				{
					return false;
				}

				// What is left should be a number
				var multiplier = string.substr(0, i) * (plus ? 1 : -1);

				if (start)
				{
					date.setHours(0);
					date.setMinutes(0);
					date.setSeconds(0);
				}

				if (unit == 'day')
				{
					date.setDate(date.getDate() + multiplier);
				}

				if (unit == 'month')
				{
					if (start)
					{
						date.setDate(1);
					}

					date.setMonth(date.getMonth() + multiplier);
				}

				if (unit == 'year')
				{
					if (start)
					{
						date.setDate(1);
						date.setMonth(0);
					}

					date.setFullYear(date.getFullYear() + multiplier);
				}
			}

			return [date.getFullYear() + '-' + (date.getMonth() + 1) + '-' + date.getDate(), date.getHours(), date.getMinutes()];
		},

		setStartDate: function(string)
		{
			var formatted = this.formatStringToDate(string);

			$('.StartDate').val(formatted[0]);
			$('.StartHour').val(formatted[1]);
			$('.StartMinute').val(formatted[2]);

			this.flash('.StartDate');
		},

		setEndDate: function(string)
		{
			var formatted = this.formatStringToDate(string);

			$('.EndDate').val(formatted[0]);
			$('.EndHour').val(formatted[1]);
			$('.EndMinute').val(formatted[2]);

			this.flash('.EndDate');
		},

		setRecurring: function(recurring)
		{
			$('.Recurring input').attr('checked', recurring ? 'checked' : '');

			this.flash('.Recurring input');
		},

		flash: function(selector)
		{
			$(selector).closest('dd').css('background-color', 'rgb(255, 255, 204)').animate({backgroundColor: 'rgba(255, 255, 204, 0)'}, XenForo.speed.slow * 2);
		}
	}

	// *********************************************************************

	XenForo.register('.ProgressTextColour', 'robodn.ProgressTextColour');

	XenForo.register('.ShowDonateForm', 'robodn.ShowDonateForm');

	XenForo.register('.DonateForm', 'robodn.SubmitDonateForm');

	XenForo.register('#DonationListOptionsHandle', 'robodn.DonationListOptions');

	XenForo.register('.AmountControl', 'robodn.AmountControl');

	XenForo.register('.DatePreset', 'robodn.DatePreset');
}
(jQuery, this, document);

/*
 Color animation jQuery-plugin
 http://www.bitstorm.org/jquery/color-animation/
 Copyright 2011 Edwin Martin <edwin@bitstorm.org>
 Released under the MIT and GPL licenses.
*/
(function(d){function i(){var b=d("script:first"),a=b.css("color"),c=false;if(/^rgba/.test(a))c=true;else try{c=a!=b.css("color","rgba(0, 0, 0, 0.5)").css("color");b.css("color",a)}catch(e){}return c}function g(b,a,c){var e="rgb"+(d.support.rgba?"a":"")+"("+parseInt(b[0]+c*(a[0]-b[0]),10)+","+parseInt(b[1]+c*(a[1]-b[1]),10)+","+parseInt(b[2]+c*(a[2]-b[2]),10);if(d.support.rgba)e+=","+(b&&a?parseFloat(b[3]+c*(a[3]-b[3])):1);e+=")";return e}function f(b){var a,c;if(a=/#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})/.exec(b))c=
[parseInt(a[1],16),parseInt(a[2],16),parseInt(a[3],16),1];else if(a=/#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])/.exec(b))c=[parseInt(a[1],16)*17,parseInt(a[2],16)*17,parseInt(a[3],16)*17,1];else if(a=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(b))c=[parseInt(a[1]),parseInt(a[2]),parseInt(a[3]),1];else if(a=/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9\.]*)\s*\)/.exec(b))c=[parseInt(a[1],10),parseInt(a[2],10),parseInt(a[3],10),parseFloat(a[4])];return c}
d.extend(true,d,{support:{rgba:i()}});var h=["color","backgroundColor","borderBottomColor","borderLeftColor","borderRightColor","borderTopColor","outlineColor"];d.each(h,function(b,a){d.fx.step[a]=function(c){if(!c.init){c.a=f(d(c.elem).css(a));c.end=f(c.end);c.init=true}c.elem.style[a]=g(c.a,c.end,c.pos)}});d.fx.step.borderColor=function(b){if(!b.init)b.end=f(b.end);var a=h.slice(2,6);d.each(a,function(c,e){b.init||(b[e]={a:f(d(b.elem).css(e))});b.elem.style[e]=g(b[e].a,b.end,b.pos)});b.init=true}})(jQuery);