/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	// *********************************************************************	
	// insert error display into the form
	XenForo.UNCForm = function($form)
	{
		var $placeholder = $('#ErrorPlaceholder');
		
		$form.bind('AutoValidationComplete', function(e)
		{		
			// check that templateHtml was received from the AJAX request
			if (e.ajaxData.templateHtml)
			{
				// prevent the normal AutoValidator success message and redirect stuff
				e.preventDefault();
				
				new XenForo.ExtLoader(e.ajaxData, function()
				{
					$placeholder.text('');
					
					// append the templateHtml into the groups list
					$(e.ajaxData.templateHtml).xfInsert('appendTo', $placeholder, 'xfFadeIn');
				});
			}
		});
	};
	
	// *********************************************************************

	XenForo.register('#UNCForm', 'XenForo.UNCForm');
}
(jQuery, this, document);