/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	XenForo.SocialForum = function($select)
	{
		var $container = $($select.data('container')),
			$nodeControl = $($select.data('nodecontrol')),
			socialForumCache = {};
		
		function updateSocialForumSelection(socialForums)
		{
			$select.find('option').empty().remove();

			$.each(socialForums, function(socialForumId, socialForum)
			{
				socialForumId = socialForum.social_forum_id;
				$('<option />').attr('value', socialForumId).text(socialForum.title).appendTo($select);
			});
			toggleSelect();
		}
		
		function toggleSelect()
		{
			if ($select.find('option').length) {
				$container.show();
			} else {
				$container.hide();
			}
		}

		if ($nodeControl.length && $select.data('socialforumurl'))
		{
			$nodeControl.change(function(e)
			{
				var nodeId = $nodeControl.val(),
					socialForumUrl = $select.data('socialforumurl'),
					xhr = null;

				if (socialForumCache[nodeId])
				{
					updateSocialForumSelection(socialForumCache[nodeId]);
					return;
				}
				else if (socialForumUrl)
				{
					if (xhr)
					{
						xhr.abort();
					}

					xhr = XenForo.ajax(socialForumUrl, { node_id: nodeId }, function(ajaxData, textStatus)
					{
						xhr = null;

						if (XenForo.hasResponseError(ajaxData))
						{
							return false;
						}

						if (ajaxData.socialForums)
						{
							socialForumCache[nodeId] = ajaxData.socialForums;
							updateSocialForumSelection(ajaxData.socialForums);
						}
					});
				}
			});
		}
		
		toggleSelect();
	};

	// *********************************************************************

	XenForo.register('select.SocialForum', 'XenForo.SocialForum');

}
(jQuery, this, document);