<?php

/**
 * Controller for handling actions on forums.
 *
 * @package XenForo_Forum
 */
class Akinak_ShowNodeModerators_ControllerPublic_Forum extends XFCP_Akinak_ShowNodeModerators_ControllerPublic_Forum
{
	public function actionIndex()
	{
		$responseView = parent::actionIndex();

		$modModel = XenForo_Model::create('XenForo_Model_Moderator');
		if(!($responseView instanceof XenForo_ControllerResponse_View))
		{
			return $responseView;
		}

		if (isset($responseView->params['forum']))
		{

		$forum = $responseView->params['forum'];
		if (XenForo_Application::get('options')->show_in_forum_view)
		{
			$moderators=$modModel->getNodeModersByForum($forum);
			$responseView->params['moderators']=$moderators;
		}


		if (XenForo_Application::get('options')->show_in_node_list)
		{

		if (isset($responseView->params['nodeList']['nodesGrouped'][$forum['node_id']]))
		{
			$nodesGrouped = $responseView->params['nodeList']['nodesGrouped'][$forum['node_id']];
			foreach ($nodesGrouped as $key=>$node)
			{
				$nodesGrouped[$key]['moderators']=$modModel->getNodeModersByForum($node);
			}
			$responseView->params['nodeList']['nodesGrouped'][$forum['node_id']]=$nodesGrouped;
		}

		}
		}
		else
		{
			if (XenForo_Application::get('options')->show_in_node_list)
			{

				if (isset($responseView->params['nodeList']['nodesGrouped']))
				{

					$nodesGrouped = $responseView->params['nodeList']['nodesGrouped'];
					foreach ($nodesGrouped as $key=>$node)
					{
						foreach ($node as $k2=>$nod)
						{
							if ((array_key_exists('node_id',$nod)) AND ($nod['depth']<2))
							{
								$nodesGrouped[$key][$k2]['moderators']=$modModel->getNodeModersByForum($nod);
							}

						}

					}
					$responseView->params['nodeList']['nodesGrouped']=$nodesGrouped;
				}
			}
		}
		return $responseView;
	}

}