<?php

class Andy_AutoDelete_CronEntry_AutoDelete
{
	public static function runWeeklyAutoDelete()
	{
		//########################################
		// get options
		//########################################
		
		// get options from Admin CP -> Options -> Auto Delete -> Days
		$days = XenForo_Application::get('options')->autoDeleteDays;
		
		// get options from Admin CP -> Options -> Auto Delete -> Forums
		$forums = XenForo_Application::get('options')->autoDeleteForums;
		
		// verify forums
		if ($forums != '')
		{
			//########################################
			// prepare variables
			//########################################	
			
			// convert to Unix timesatmp
			$timestamp = time() - (86400 * $days);		
			
			// remove trailing comma if there is one
			$forums = rtrim($forums, ',');			
			
			// put into array
			$forumsArray = explode(',', $forums); 
		
			// create whereclause
			$whereclause = 'AND (xf_thread.node_id = ' . implode(' OR xf_thread.node_id = ', $forumsArray);
			$whereclause = $whereclause . ')';			
	
			//########################################
			// run database query
			//########################################
			
			// get database
			$db = XenForo_Application::get('db');		
			
			$threads = $db->fetchAll("
			SELECT xf_thread.thread_id
			FROM xf_thread
			INNER JOIN xf_node ON xf_node.node_id = xf_thread.node_id
			WHERE xf_thread.last_post_date < " . $timestamp . "
			AND xf_thread.sticky = 0
			$whereclause
			");								
	
			//########################################
			// delete threads
			//######################################## 
			
			foreach ($threads AS $k => $v)
			{			
				$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
				$dw->setExistingData($v);
				$dw->delete();
			}
		}
	}
}