<?php

class Andy_AutoLock_CronEntry_AutoLock
{
	public static function runWeeklyAutoLock()
	{
		//########################################
		// get options
		//########################################
		
		// get options from Admin CP -> Options -> Auto Lock -> Days
		$days = XenForo_Application::get('options')->autoLockDays;
		
		// get options from Admin CP -> Options -> Auto Lock -> Forums
		$forums = XenForo_Application::get('options')->autoLockForums;	
		
		// verify forums
		if ($forums != '')
		{
			//########################################
			// prepare variables
			//########################################	
			
			// convert to Unix timesatmp
			$timestamp = time() - (86400 * $days);		
			
			// remove trailing comma if there is one
			$forums = rtrim($forums, ',');			
			
			// put into array
			$forumsArray = explode(',', $forums); 
		
			// create whereclause
			$whereclause = 'AND (xf_thread.node_id = ' . implode(' OR xf_thread.node_id = ', $forumsArray);
			$whereclause = $whereclause . ')';			
	
			//########################################
			// run database query
			//########################################
			
			// get database
			$db = XenForo_Application::get('db');		
			
			$threads = $db->fetchAll("
			SELECT xf_thread.thread_id
			FROM xf_thread
			INNER JOIN xf_node ON xf_node.node_id = xf_thread.node_id
			WHERE xf_thread.last_post_date < " . $timestamp . "
			AND xf_thread.sticky = 0
			$whereclause
			");								
	
			//########################################
			// close threads
			//########################################			
			
			foreach ($threads AS $k => $v)
			{
				// run query
				$db->query('
					UPDATE xf_thread SET
						discussion_open = "0"
					WHERE thread_id = ?
				', $v);
			}
		}
	}
}