<?php

class Andy_ChangeAuthor_ControllerPublic_Post extends XFCP_Andy_ChangeAuthor_ControllerPublic_Post
{
	public function actionChangeAuthor()
	{
		// get userId
		$userId = XenForo_Visitor::getUserId();
		
		// throw error if not logged in
		if (!$userId)
		{
			throw $this->getNoPermissionResponseException();
		}			
		
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('changeAuthorGroupID', 'changeAuthorID'))
		{
			throw $this->getNoPermissionResponseException();
		}
				
		// get post_id from route, example /forums/posts/12345/changeauthor
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);
		
		// get post variables
		$post = $this->getModelFromCache('XenForo_Model_Post')->getPostById($postId);
		
		// prepare viewParams
		$viewParams = array(
			'post' => $post,
		);
		
		// send to template
		return $this->responseView('Andy_ChangeAuthor_ViewPublic_Post','andy_changeauthor',$viewParams);
	}
	
	public function actionChangeAuthorSave()
	{		
		// get userId
		$userId = XenForo_Visitor::getUserId();
		
		// throw error if not logged in
		if (!$userId)
		{
			throw $this->getNoPermissionResponseException();
		}			
		
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('changeAuthorGroupID', 'changeAuthorID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		// make sure data comes from $_POST
		$this->_assertPostOnly();		
		
		// get post_id
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);
		
		// get username from overlay
		$newPostAuthor = $this->_input->filterSingle('new_post_author', XenForo_Input::STRING);
		
		// get database
		$db = XenForo_Application::get('db');	
		
		// get userId
		$user = $db->fetchRow("
		SELECT user_id, username
		FROM xf_user
		WHERE username = ?
		", $newPostAuthor);	
		
		// verify username is valid
		if ($user['user_id'] == '')
		{
			throw new XenForo_Exception(new XenForo_Phrase('changeauthor_invalid_username'), true);
		}
		
		// get post user_id
		$currentPostUserId = $db->fetchOne("
		SELECT user_id
		FROM xf_post
		WHERE post_id = ?
		", $postId);
		
		if ($currentPostUserId == $user['user_id'])
		{
			throw new XenForo_Exception(new XenForo_Phrase('changeauthor_username_entered_is_already_the_post_author'), true);
		}		
		
		//########################################
		// start database operations
		//########################################
		
		// declare variables
		$firstPost = '';
		$lastPost = '';
				
		// check thread info if first post
		$thread = $db->fetchRow("
		SELECT thread_id, node_id, first_post_id
		FROM xf_thread
		WHERE first_post_id = ?
		", $postId);
		
		if ($thread['thread_id'] != '')
		{
			$firstPost = 'yes';
		}
		
		//########################################
		// first post
		
		if ($firstPost == 'yes')
		{
			// update xf_post
			$db->query('
				UPDATE xf_post SET
					user_id = "' . $user['user_id'] . '", username = "' . $user['username'] . '"
				WHERE post_id = ?
			', $postId);
						
			// update xf_thread
			$db->query('
				UPDATE xf_thread SET
					user_id = "' . $user['user_id'] . '", username = "' . $user['username'] . '", last_post_user_id = "' . $user['user_id'] . '", last_post_username = "' . $user['username'] . '"
				WHERE thread_id = ?
			', $thread['thread_id']);			
			
			// update xf_forum
			$db->query('
				UPDATE xf_forum SET
					last_post_user_id = "' . $user['user_id'] . '", last_post_username = "' . $user['username'] . '"
				WHERE node_id = ?
			', $thread['node_id']);					
		}
		
		//########################################
		// if not first post
		
		if ($firstPost != 'yes')
		{
			// get thread_id
			$threadId = $db->fetchOne("
			SELECT thread_id
			FROM xf_post
			WHERE post_id = ?
			", $postId);
			
			// clear array
			unset($thread);
			
			// check if last post
			$thread = $db->fetchRow("
			SELECT node_id, last_post_id
			FROM xf_thread
			WHERE thread_id = ?
			", $threadId);
			
			if ($thread['last_post_id'] == $postId)
			{
				$lastPost = 'yes';
			}
			
			// update xf_post
			$db->query('
				UPDATE xf_post SET
					user_id = "' . $user['user_id'] . '", username = "' . $user['username'] . '"
				WHERE post_id = ?
			', $postId);
			
			// update if last post
			if ($lastPost == 'yes')
			{
				// update xf_thread
				$db->query('
					UPDATE xf_thread SET
						last_post_user_id = "' . $user['user_id'] . '", last_post_username = "' . $user['username'] . '"
					WHERE thread_id = ?
				', $threadId);
				
				// update xf_forum
				$db->query('
					UPDATE xf_forum SET
						last_post_user_id = "' . $user['user_id'] . '", last_post_username = "' . $user['username'] . '"
					WHERE node_id = ?
				', $thread['node_id']);					
			}
		}
		
		//########################################
		// update xf_attachment_data
		
		$db->query('
			UPDATE xf_attachment_data 
			INNER JOIN xf_attachment ON xf_attachment.data_id = xf_attachment_data.data_id
			SET	xf_attachment_data.user_id = "' . $user['user_id'] . '"
			WHERE xf_attachment.content_type = "post"
			AND xf_attachment.content_id = ?
		', $postId);
		
		//########################################
		// update xf_user 
		
		// run query
		$countMessages = $db->fetchOne("
		SELECT count_messages
		FROM xf_forum
		WHERE node_id = ?
		", $thread['node_id']);	
		
		if ($countMessages)
		{
			// update xf_user (original author)
			$db->query('
				UPDATE xf_user SET
					message_count = message_count - 1
				WHERE user_id = ?
				AND message_count > 0
			', $currentPostUserId);	
			
			// update xf_user (new author)
			$db->query('
				UPDATE xf_user SET
					message_count = message_count + 1
				WHERE user_id = ?
			', $user['user_id']);
		}
		
		//########################################
		// this query is used to update 
		// xf_search_index and ElasticSearch index
		
		// run query
		$data = $db->fetchRow("
		SELECT xf_thread.node_id, 
		xf_thread.thread_id, 
		xf_thread.title, 
		xf_post.message, 
		xf_post.post_date, 
		xf_post.user_id
		FROM xf_post
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
		WHERE xf_post.post_id = ?
		", $postId);		
		
		//########################################
		// update xf_search_index
		
		// check if ElasticSearch is not enabled
		if (!XenForo_Application::get('options')->enableElasticsearch)
		{
			// run query
			$metadata = $db->fetchOne("
			SELECT metadata
			FROM xf_search_index
			WHERE content_type = 'post'
			AND content_id = ?
			", $postId);
			
			// define metadata			
			$metadata = '_md_user_' . $data['user_id'] . ' ' . '_md_content_post' . ' ' . '_md_node_' . $data['node_id'] . ' ' . '_md_thread_' . $data['thread_id'];
			
			// run query
			$db->query('
				UPDATE xf_search_index SET
					user_id = "' . $user['user_id'] . '", metadata = "' . $metadata . '"
				WHERE content_type = "post"
				AND content_id = ?
			', $postId);
			
			if ($firstPost == 'yes')
			{
				// run query
				$metadata = $db->fetchOne("
				SELECT metadata
				FROM xf_search_index
				WHERE content_type = 'thread'
				AND content_id = ?
				", $data['thread_id']);
				
				// define metadata			
				$metadata = '_md_user_' . $data['user_id'] . ' ' . '_md_content_thread' . ' ' . '_md_node_' . $data['node_id'] . ' ' . '_md_thread_' . $data['thread_id'];
				
				// run query
				$db->query('
					UPDATE xf_search_index SET
						user_id = "' . $user['user_id'] . '", metadata = "' . $metadata . '"
					WHERE content_type = "thread"
					AND content_id = ?
				', $data['thread_id']);
			}
		}
		
		//########################################
		// update ElasticSearch index
		
		// check if ElasticSearch is enabled
		if (XenForo_Application::get('options')->enableElasticsearch)
		{				
			// get ElasticSearch index name
			$indexName = XenES_Api::getInstance()->getIndex();		
			
			// define variables
			$contentType = 'post';
			$contentId = $postId;
			
			// define record data
			$record = array(
				'node' => $data['node_id'],
				'thread' => $data['thread_id'],
				'title' => $data['title'], 
				'message' => $data['message'],
				'date' => $data['post_date'],
				'user' => $data['user_id'],
				'discussion_id' => $postId
			);

			// update ElasticSearch index
			XenES_Api::index($indexName, $contentType, $contentId, $record);
			
			if ($firstPost == 'yes')
			{
				// define variables
				$contentType = 'thread';
				$contentId = $data['thread_id'];				
					
				// define record data
				$record = array(
					'node' => $data['node_id'],
					'thread' => $data['thread_id'],
					'title' => $data['title'], 
					'message' => $data['message'],
					'date' => $data['post_date'],
					'user' => $data['user_id'],
					'discussion_id' => $data['thread_id']
				);
	
				// update ElasticSearch index
				XenES_Api::index($indexName, $contentType, $contentId, $record);
			}
		}

		//########################################
		// return with response redirect
		//######################################## 
		
		// prepare variables for redirect
		$post['post_id'] = $postId;
		$changesSaved = new XenForo_Phrase('changeauthor_changes_saved');		
				
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('posts', $post), $changesSaved);			
	} 
}