<?php

class Andy_DeletePosts_ControllerPublic_DeletePosts extends XenForo_ControllerPublic_Abstract
{	
	public function actionIndex()
	{	
		// get permission
		if (!XenForo_Visitor::getInstance()->hasPermission('deletePostsGroupID', 'deletePostsID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		// get database
		$db = XenForo_Application::get('db');
		
		// run query
		$addonId = $db->fetchOne("
		SELECT addon_id
		FROM xf_addon
		WHERE addon_id = 'ShowDeleted'
		AND active = 1
		");	

		// throw error if Show Deleted add-on is active
		if ($addonId)
		{
			 return $this->responseError(new XenForo_Phrase('deleteposts_showdeleted_addon_must_be_disabled'));
		}
	
		// send to template
		return $this->responseView('Andy_DeletePosts_ViewPublic_DeletePosts', 'andy_deleteposts');
	}
}