<?php

class Andy_DeletePosts_ControllerPublic_Post extends XFCP_Andy_DeletePosts_ControllerPublic_Post
{
	public function actionDeleteContent()
	{
		// get permission
		if (!XenForo_Visitor::getInstance()->hasPermission('deletePostsGroupID', 'deletePostsID'))
		{
			throw $this->getNoPermissionResponseException();
		}		
		
		// get username
		$username = $this->_input->filterSingle('username', XenForo_Input::STRING);	
		
		// verify username
		if ($username == '')
		{
			return $this->responseError(new XenForo_Phrase('deleteposts_username_missing'));
		}
		
		// get limit
		$limit = $this->_input->filterSingle('limit', XenForo_Input::STRING);	
		
		// make sure we have a number greater than zero
		if ($limit == '0')
		{
			return $this->responseError(new XenForo_Phrase('deleteposts_limit_cannot_be_zero'));
		}
		
		// get posts with limit		
		if ($limit == '')
		{		
			// get posts from model
			$posts = $this->getModelFromCache('Andy_DeletePosts_Model')->getPosts($username);
		}
		
		if ($limit != '')
		{
			if (!is_numeric($limit))
			{
				return $this->responseError(new XenForo_Phrase('deleteposts_limit_must_be_numeric'));
			}
								
			// get posts from model
			$posts = $this->getModelFromCache('Andy_DeletePosts_Model')->getPostsLimit($username,$limit);
		}		
		
		// if no posts return response error
		if (empty($posts))
		{
			return $this->responseError(new XenForo_Phrase('deletePosts_posts_by_this_username_not_found'));
		}
		
		// get database
		$db = XenForo_Application::get('db');				
		
		foreach ($posts as $k => $v)
		{ 
			// get postId
			$postId = $v['post_id'];
			
			// run query
			$postExists = $db->fetchOne("
			SELECT post_id
			FROM xf_post
			WHERE post_id = '$postId'
			");	
			
			if ($postExists)
			{
				$ftpHelper = $this->getHelper('ForumThreadPost');
				list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
		
				$hardDelete = $this->_input->filterSingle('hard_delete', XenForo_Input::UINT);
				$deleteType = 'hard';
		
				$this->_assertCanDeletePost($post, $thread, $forum, $deleteType);
		
				$postModel = $this->_getPostModel();
		
				$options = array(
					'reason' => ''
				);
		
				$dw = $postModel->deletePost($postId, $deleteType, $options, $forum);
		
				if ($post['post_id'] == $thread['first_post_id'])
				{
					XenForo_Model_Log::logModeratorAction(
						'thread', $thread, 'delete_' . $deleteType, array('reason' => $options['reason'])
					);
				}
				else
				{
					XenForo_Model_Log::logModeratorAction(
						'post', $post, 'delete_' . $deleteType, array('reason' => $options['reason']), $thread
					);
				}
				
				XenForo_Db::commit();
			}
		}
		
		$confirmMessage = new XenForo_Phrase('deleteposts_posts_successfully_deleted');
	
		// return to showdeleted
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('deleteposts/'), $confirmMessage);
	}
}