<?php

class Andy_FirstPost_ControllerPublic_Forum extends XFCP_Andy_FirstPost_ControllerPublic_Forum
{
    public function actionCreateThread()
    {
		// get parent
		$parent = parent::actionCreateThread();
		
		// get user information
		$user = XenForo_Visitor::getInstance();
		$messageCount = $user['message_count']; 
		
		if ($messageCount == 0)
		{
			// get nodeId		
			$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
			$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
			$ftpHelper = $this->getHelper('ForumThreadPost');
			$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);
			$nodeId = $forum['node_id'];

			// get options from Admin CP -> Options -> First Post -> Introductory Forum   
			$introductoryForum = XenForo_Application::get('options')->introductoryForum;
			
			if ($nodeId != $introductoryForum)
			{
				return $this->responseError(new XenForo_Phrase('this_forum_requires_new_member_introductions'));	
			}
		}
		
		// return parent
		return $parent;
    }
}

?>