<?php

class Andy_InactiveMembers_ControllerPublic_InactiveMembers extends XenForo_ControllerPublic_Abstract
{	
	public function actionIndex()
	{
		//########################################
		// Display main menu.
		//########################################		
			
		//########################################
		// permissions
		//########################################	
			
		// get userId
		$userId = XenForo_Visitor::getUserId();
		
		// throw error if no userId
		if ($userId == '')
		{
			throw $this->getNoPermissionResponseException();
		}	
				
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('inactiveMembersGroupID', 'inactiveMembersID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		//########################################
		// get email of visitor
		// needed in order to create link for
		// sample email
		//########################################
				
		// get userId
		$userId = XenForo_Visitor::getUserId();		

		// get database
		$db = XenForo_Application::get('db');
				
		// run query
		$emailVisitor = $db->fetchOne("
		SELECT email
		FROM xf_user
		WHERE user_id = " . $userId . "
		LIMIT 1
		");	
		
		//########################################
		// get emails
		//########################################	
		
		// get options from Admin CP -> Options -> Inactive Members -> Minimum Days
		$minimumDays = XenForo_Application::get('options')->inactiveMembersMinimumDays;
		
		// get options from Admin CP -> Options -> Inactive Members -> Maximum Days
		$maximumDays = XenForo_Application::get('options')->inactiveMembersMaximumDays;	
		
		// convert to UNIX timestamp
		$datelineMin = time() - (86400 * $minimumDays);	
		$datelineMax = time() - (86400 * $maximumDays);
		
		// get options from Admin CP -> Options -> Inactive Members -> Minumum Posts
		$minimumPosts = XenForo_Application::get('options')->inactiveMembersMinimumPosts;
		
		// get options from Admin CP -> Options -> Inactive Members -> Maximum Posts
		$maximumPosts = XenForo_Application::get('options')->inactiveMembersMaximumPosts;
		
		//########################################
		// Exclude these user groups.
		//########################################	
		
		// declare variable
		$whereclause2 = '';	
		
		// get options from Admin CP -> Options -> Inactive Members -> Exclude User Groups
		$excludeUserGroups = XenForo_Application::get('options')->inactiveMembersExcludeUserGroups;			
	
		if ($excludeUserGroups != '')
		{	
			$excludeUserGroupsArray = explode(',', $excludeUserGroups);		
			
			// create whereclause2 of excluded user groups
			$whereclause2 = 'AND (xf_user.secondary_group_ids != ' . implode(' AND xf_user.secondary_group_ids != ', $excludeUserGroupsArray);
			$whereclause2 = $whereclause2 . ')';
		}

		// get emails from model    
		$emails = $this->getModelFromCache('Andy_InactiveMembers_Model')->getEmails($datelineMin,$datelineMax,$minimumPosts,$maximumPosts,$whereclause2);														

		// get emailCount
		$emailCount = count($emails);	
		
		// prepare viewParams for template
		$viewParams = array(
			'emailCount' => $emailCount,
			'emailVisitor' => $emailVisitor,
			'minimumDays' => $minimumDays,
			'maximumDays' => $maximumDays,
			'minimumPosts' => $minimumPosts,
			'maximumPosts' => $maximumPosts
		); 
		
		// send to template for display
		return $this->responseView('Andy_InactiveMembers_ViewPublic_InactiveMembers', 'andy_inactivemembers', $viewParams);
	}
	
	public function actionSendSample()
	{
		//########################################
		// Send sample email.
		//########################################
		
		//########################################
		// permissions
		//########################################	
			
		// get userId
		$userId = XenForo_Visitor::getUserId();
		
		// throw error if no userId
		if ($userId == '')
		{
			throw $this->getNoPermissionResponseException();
		}	
				
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('inactiveMembersGroupID', 'inactiveMembersID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		//########################################
		// This will select threads not older
		// than this many "days".
		//########################################			
		
		// get options from Admin CP -> Options -> Inactive Members -> Days
		$days = XenForo_Application::get('options')->inactiveMembersDays;		
		
		// calculate dateline
		$dateline = time() - (86400 * $days);					
		
		//########################################
		// Only these forums will queried for the
		// most popular thread titles.
		//########################################		
		
		// get options from Admin CP -> Options -> Inactive Members -> Include Forums
		$includeForums = XenForo_Application::get('options')->inactiveMembersIncludeForums;	
		
		if ($includeForums == '')
		{
			throw new XenForo_Exception(new XenForo_Phrase('inactivemembers_error_forums'), true);
		}
		
		// remove trailing comma
		$includeForums = rtrim($includeForums, ',');					
		
		$nodeIds = explode(',', $includeForums);		
		
		// create whereclause of excluded forums
		$whereclause1 = 'AND (xf_thread.node_id = ' . implode(' OR xf_thread.node_id = ', $nodeIds);
		$whereclause1 = $whereclause1 . ')';
		
		//########################################
		// The number of title rows is determined 
		// by this "limit".
		//########################################			
		
		// get options from Admin CP -> Options -> Inactive Members -> Limit
		$limit = XenForo_Application::get('options')->inactiveMembersLimit;		
		
		//########################################
		// get threads
		//########################################
		
		// get threads from model    
		$threads = $this->getModelFromCache('Andy_InactiveMembers_Model')->getThreads($dateline,$whereclause1,$limit);
		
		//########################################
		// get username and email of visitor
		//########################################
				
		// get $userId
		$userId = XenForo_Visitor::getUserId();	
		
		// get database
		$db = XenForo_Application::get('db');			
		
		// run query
		$to = $db->fetchRow("
		SELECT username, email
		FROM xf_user
		WHERE user_id = " . $userId . "
		LIMIT 1
		");				
		
		//########################################
		// start message
		//########################################
		
		// get options from Admin CP -> Options -> Basic Board Information -> Board Title
		$boardTitle = XenForo_Application::get('options')->boardTitle;
		
		// get options from Admin CP -> Options -> Inactive Members -> Email Subject   
		$subject = XenForo_Application::get('options')->inactiveMembersEmailSubject;
		
		// get options from Admin CP -> Options -> Basic Board Information -> Use Full Friendly URLs
		$useFriendlyUrls = XenForo_Application::get('options')->useFriendlyUrls;					
		
		// message
		$message = new XenForo_Phrase('inactivemembers_message') . '<br /><br />';
		
		// replace {username} in message
		$message = str_replace('{username}', $to['username'], $message);
		
		// get internal_data path
		$webRoot =  XenForo_Link::buildPublicLink('full:index');
		
		// start table
		$message .= '
<table cellspacing="5">
<tr>
<th align="left">Forum</th>
<th align="left">Title</th>
</tr>';
	
		// convert multidimensional array
		foreach ($threads as $k => $v)
		{
			// check if using friendly URLs
			if ($useFriendlyUrls == 1)
			{				
				// message details
				$message .= '<tr><td>' . $v['forumTitle'] . '</td>';
				$message .= '<td>' . '<a href="' . $webRoot . 'threads/' . $v['thread_id'] . '/' . '">' . $v['threadTitle'] . '</a></td></tr>';
			}
			else
			{
				// message details
				$message .= '<tr><td>' . $v['forumTitle'] . '</td>';
				$message .= '<td>' . '<a href="' . $webRoot . '?threads/' . $v['thread_id'] . '/' . '">' . $v['threadTitle'] . '</a></td></tr>';
			}	
		}
		
		// end table
		$message .= '</tr></table>';
		
		//########################################
		// add unsubscribe and forgot password
		//########################################

		// message
		$message .= '<br /><br />' . new XenForo_Phrase('inactivemembers_unsubscribe') . '<br /><br />';
		
		// create unsubscribeLink
		if ($useFriendlyUrls == 1)
		{
			$unsubscribeLink = $webRoot . 'account/contact-details';
		}
		else
		{
			$unsubscribeLink = $webRoot . '?account/contact-details';
		}
		
		// add unsubscribeLink to message
		$message = str_replace('{unsubscribe_link}', $unsubscribeLink, $message);	
		
		// create forgotPasswordLink
		if ($useFriendlyUrls == 1)
		{		
			$forgotPasswordLink = $webRoot . 'lost-password/';
		}
		else
		{
			$forgotPasswordLink = $webRoot . '?lost-password/';
		}
		
		// add forgotPasswordLink
		$message = str_replace('{forgotpassword_link}', $forgotPasswordLink, $message);	
		
		//########################################
		// replace {board_title} in message
		//########################################		
		
		$message = str_replace('{board_title}', $boardTitle, $message);			
	
		//########################################
		// send email
		//########################################
		
		// get visitor data
		$visitor = XenForo_Visitor::getInstance();
		
		// username
		$username = $visitor['username'];
		
		// email 
		$email = $visitor['email'];
		
		// define user variable
		$user = array(
			'username' => $username,
			'email' => $email
		);
		
		// prepare mailParams                    
		$mailParams = array(
			'user' => $user,
			'subject' => $subject,
			'message' => $message
		);
			
		// prepare mail variable
		$mail = XenForo_Mail::create('inactivemembers_contact', $mailParams);
		
		// send mail to queue
		$mail->queue($user['email'], $user['username']);
		
		//########################################
		// return confirmation message
		//########################################
		
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('inactivemembers/sampleconfirm')
		);
	}
	
	public function actionSendBatch()
	{
		//########################################
		// Send batch emails.
		//########################################
		
		//########################################
		// permissions
		//########################################	
			
		// get userId
		$userId = XenForo_Visitor::getUserId();
		
		// throw error if no userId
		if ($userId == '')
		{
			throw $this->getNoPermissionResponseException();
		}	
				
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('inactiveMembersGroupID', 'inactiveMembersID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		//########################################
		// Select threads not older
		// than this many "days".
		//########################################			
		
		// get options from Admin CP -> Options -> Inactive Members -> Days
		$days = XenForo_Application::get('options')->inactiveMembersDays;		
		
		// calculate dateline
		$dateline = time() - (86400 * $days);					
		
		//########################################
		// Only these forums will queried for the
		// most popular thread titles.
		//########################################		
		
		// get options from Admin CP -> Options -> Inactive Members -> Include Forums
		$includeForums = XenForo_Application::get('options')->inactiveMembersIncludeForums;	
		
		if ($includeForums == '')
		{
			throw new XenForo_Exception(new XenForo_Phrase('inactivemembers_error_forums'), true);
		}	
		
		// remove trailing comma
		$includeForums = rtrim($includeForums, ',');				
		
		$nodeIds = explode(',', $includeForums);		
		
		// create whereclause1 of included forums
		$whereclause1 = 'AND (xf_thread.node_id = ' . implode(' OR xf_thread.node_id = ', $nodeIds);
		$whereclause1 = $whereclause1 . ')';
		
		//########################################
		// Exclude these user groups.
		//########################################	
		
		// declare variable
		$whereclause2 = '';	
		
		// get options from Admin CP -> Options -> Inactive Members -> Exclude User Groups
		$excludeUserGroups = XenForo_Application::get('options')->inactiveMembersExcludeUserGroups;			

		if ($excludeUserGroups != '')
		{
			// remove trailing comma
			$excludeUserGroups = rtrim($excludeUserGroups, ',');			
			
			// make array	
			$excludeUserGroupsArray = explode(',', $excludeUserGroups);		
			
			// create whereclause2 of excluded user groups
			$whereclause2 = 'AND (xf_user.secondary_group_ids != ' . implode(' AND xf_user.secondary_group_ids != ', $excludeUserGroupsArray);
			$whereclause2 = $whereclause2 . ')';
		}
		
		//########################################
		// The number of title rows is determined 
		// by this "limit".
		//########################################			
		
		// get options from Admin CP -> Options -> Inactive Members -> Limit
		$limit = XenForo_Application::get('options')->inactiveMembersLimit;
		
		//########################################
		// get threads
		//########################################
		
		// get threads from model    
		$threads = $this->getModelFromCache('Andy_InactiveMembers_Model')->getThreads($dateline,$whereclause1,$limit);
		
		//########################################
		// get emails
		//########################################	
		
		// get options from Admin CP -> Options -> Inactive Members -> Minimum Days
		$minimumDays = XenForo_Application::get('options')->inactiveMembersMinimumDays;
		
		// get options from Admin CP -> Options -> Inactive Members -> Maximum Days
		$maximumDays = XenForo_Application::get('options')->inactiveMembersMaximumDays;	
		
		// convert to UNIX timestamp
		$datelineMin = time() - (86400 * $minimumDays);	
		$datelineMax = time() - (86400 * $maximumDays);
		
		// get options from Admin CP -> Options -> Inactive Members -> Minumum Posts
		$minimumPosts = XenForo_Application::get('options')->inactiveMembersMinimumPosts;
		
		// get options from Admin CP -> Options -> Inactive Members -> Maximum Posts
		$maximumPosts = XenForo_Application::get('options')->inactiveMembersMaximumPosts;										
		
		// get emails from model    
		$emails = $this->getModelFromCache('Andy_InactiveMembers_Model')->getEmails($datelineMin,$datelineMax,$minimumPosts,$maximumPosts,$whereclause2);			
		
		//########################################
		// start message
		//########################################
		
		// get options from Admin CP -> Options -> Basic Board Information -> Board Title
		$boardTitle = XenForo_Application::get('options')->boardTitle;		
		
		// get options from Admin CP -> Options -> Inactive Members -> Email Subject   
		$subject = XenForo_Application::get('options')->inactiveMembersEmailSubject;
		
		// get options from Admin CP -> Options -> Basic Board Information -> Use Full Friendly URLs
		$useFriendlyUrls = XenForo_Application::get('options')->useFriendlyUrls;						
		
		// message
		$message = new XenForo_Phrase('inactivemembers_message') . '<br /><br />';	
		
		// get internal_data path
		$webRoot =  XenForo_Link::buildPublicLink('full:index');
		
		// start table
		$message .= '
<table cellspacing="5">
<tr>
<th align="left">Forum</th>
<th align="left">Title</th>
</tr>';
	
		// convert multidimensional array
		foreach ($threads as $k => $v)
		{
			// check if using friendly URLs	
			if ($useFriendlyUrls == 1)
			{				
				// message details
				$message .= '<tr><td>' . $v['forumTitle'] . '</td>';
				$message .= '<td>' . '<a href="' . $webRoot . 'threads/' . $v['thread_id'] . '/' . '">' . $v['threadTitle'] . '</a></td></tr>';
			}
			else
			{
				// message details
				$message .= '<tr><td>' . $v['forumTitle'] . '</td>';
				$message .= '<td>' . '<a href="' . $webRoot . '?threads/' . $v['thread_id'] . '/' . '">' . $v['threadTitle'] . '</a></td></tr>';
			}	
		}
		
		// end table
		$message .= '</tr></table>';
		
		//########################################
		// add unsubscribe and forgot password
		//########################################

		// message
		$message .= '<br /><br />' . new XenForo_Phrase('inactivemembers_unsubscribe') . '<br /><br />';
		
		// create unsubscribeLink
		if ($useFriendlyUrls == 1)
		{
			$unsubscribeLink = $webRoot . 'account/contact-details';
		}
		else
		{
			$unsubscribeLink = $webRoot . '?account/contact-details';
		}
		
		// add unsubscribeLink to message
		$message = str_replace('{unsubscribe_link}', $unsubscribeLink, $message);	
		
		// create forgotPasswordLink
		if ($useFriendlyUrls == 1)
		{		
			$forgotPasswordLink = $webRoot . 'lost-password/';
		}
		else
		{
			$forgotPasswordLink = $webRoot . '?lost-password/';
		}
		
		// add forgotPasswordLink
		$message = str_replace('{forgotpassword_link}', $forgotPasswordLink, $message);	
		
		//########################################
		// replace {board_title} in message
		//########################################		
		
		$message = str_replace('{board_title}', $boardTitle, $message);			

		//########################################
		// send email
		//########################################
		
		// set to zero, no PHP time limit is imposed
		set_time_limit(0);	
		
		echo new XenForo_Phrase('inactivemembers_email_sent_to');	

		// convert multidimensional array
		foreach ($emails as $k => $v)
		{	
			// prepare $to variable
			$to = $v['email'];
			
			// replace {username} in message
			$nextMessage = str_replace('{username}', $v['username'], $message);				

			// username
			$username = $v['username'];
			
			// email 
			$email = $v['email'];
			
			// define user variable
			$user = array(
				'username' => $username,
				'email' => $email
			);
			
			// prepare mailParams                    
			$mailParams = array(
				'user' => $user,
				'subject' => $subject,
				'message' => $nextMessage
			);
				
			// prepare mail variable
			$mail = XenForo_Mail::create('inactivemembers_contact', $mailParams);
			
			// send mail
			$mail->queue($user['email'], $user['username']);
			
			echo $v['username'] . '<br />';
			flush();
		}
		
		echo '<br />' . new XenForo_Phrase('inactivemembers_finished_press_back_button_to_return_to_previous_page');
		exit();					
	}
	
	public function actionSampleConfirm()
	{	
		return $this->responseMessage(new XenForo_Phrase('inactivemembers_sendsample_confirm'));
	}	
}