<?php

class Andy_NewConversationLimit_ControllerPublic_Conversation extends XFCP_Andy_NewConversationLimit_ControllerPublic_Conversation
{
	public function actionIndex()
	{	
		// get parent
		$parent = parent::actionIndex();
		
		// get user information
		$user = XenForo_Visitor::getInstance();
		
		// get options from Admin CP -> Options -> New Conversation Limit -> New Conversation Maximum
		$newConversationMaximum = XenForo_Application::get('options')->newConversationLimitNewConversationMaximum;			
		
		// get options from Admin CP -> Options -> New Conversation Limit -> Days
		$days = XenForo_Application::get('options')->newConversationLimitDays;		
		
		// convert to Unix timesatmp
		$timestamp = time() - (86400 * $days);		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// get newConversationCount
		$newConversationCount = $db->fetchOne("
		SELECT COUNT(conversation_id)
		FROM xf_conversation_master
		WHERE user_id = " . $user['user_id'] . "
		AND start_date > " . $timestamp . "
		");	
		
		if ($newConversationCount > $newConversationMaximum)
		{
			// set variable
			$parent->params['canStartConversation'] = '';	
		}			
				
		// return parent
		return $parent;
	}
			
    public function actionAdd()
    {
		// get parent
		$parent = parent::actionAdd();
		
		// get user information
		$user = XenForo_Visitor::getInstance();	

		// get options from Admin CP -> Options -> New Conversation Limit -> New Conversation Maximum
		$newConversationMaximum = XenForo_Application::get('options')->newConversationLimitNewConversationMaximum;	
		
		// get options from Admin CP -> Options -> New Conversation Limit -> Days
		$days = XenForo_Application::get('options')->newConversationLimitDays;		
		
		// convert to Unix timesatmp
		$timestamp = time() - (86400 * $days);		
		
		// get database
		$db = XenForo_Application::get('db');
		
		// get newConversationCount
		$newConversationCount = $db->fetchOne("
		SELECT COUNT(conversation_id)
		FROM xf_conversation_master
		WHERE user_id = " . $user['user_id'] . "
		AND start_date > " . $timestamp . "
		");						
		
		if ($newConversationCount > $newConversationMaximum)
		{
			return $this->responseError(new XenForo_Phrase('do_not_have_permission'));	
		}		
		
		// return parent
		return $parent;
    }
}