<?php

class Andy_RemoveMembersTab_ControllerPublic_Member extends XFCP_Andy_RemoveMembersTab_ControllerPublic_Member
{
	public function actionIndex()
	{	
		// get parent
		$parent = parent::actionIndex();
		
		// get userId
		$userId = XenForo_Visitor::getUserId();	
		
		// get options from Admin CP -> Options -> Remove Members Tab -> Guests Only
		$guestsOnly = XenForo_Application::get('options')->removeMembersTabGuestsOnly;		
		
		// throw error if not logged in and option is selected
		if ($userId == '' AND $guestsOnly)
		{
			throw $this->getNoPermissionResponseException();
		}
		
		// throw error if logged in and option is not selected
		if ($userId > 0 AND $guestsOnly == 0)
		{
			throw $this->getNoPermissionResponseException();
		}		
		
		// return parent
		return $parent;
    }
}