<?php

class Andy_ReplyCount_ControllerPublic_Thread extends XFCP_Andy_ReplyCount_ControllerPublic_Thread
{
	public function _assertCanReplyToThread(array $thread, array $forum)
	{
		// get parent
		$parent = parent::_assertCanReplyToThread($thread, $forum);		
		
		// get permission
		if (!XenForo_Visitor::getInstance()->hasPermission('replyCountGroupID', 'replyCountID'))
		{
			// get $threadId
			$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
			
			// get database
			$db = XenForo_Application::get('db');	
			
			// get data
			$replyCount = $db->fetchOne("
			SELECT reply_count
			FROM xf_thread
			WHERE thread_id = ?
			", $threadId);
			
			// get options from Admin CP -> Options -> Reply Count -> Max Reply Limit   
			$maxReplyLimit = XenForo_Application::get('options')->replyCountMaxReplyLimit;		
			
			// if replyCount exceeds maximum allowed
			if ($replyCount > $maxReplyLimit)
			{
				// throw error message
				throw $this->getErrorOrNoPermissionResponseException(new XenForo_Phrase('replycount_maximum') . ' ' . $maxReplyLimit . ' ' . new XenForo_Phrase('replycount_posts_allowed_per_thread'));
			}
		}
	}
}