<?php

class Andy_ShowDeleted_ControllerPublic_Post extends XFCP_Andy_ShowDeleted_ControllerPublic_Post
{
	public function actionDeleteContent()
	{
		// get permission
		if (!XenForo_Visitor::getInstance()->hasPermission('showDeletedGroupID', 'showDeletedID'))
		{
			throw $this->getNoPermissionResponseException();
		}		
		
		// get type
		$type = $this->_input->filterSingle('type', XenForo_Input::STRING);	
		
		// verify type
		if ($type == '')
		{
			return $this->responseError(new XenForo_Phrase('showdeleted_type_switch_missing_from_url'));
		}
		
		// get optional limit (must be added manually)
		$limit = $this->_input->filterSingle('limit', XenForo_Input::STRING);			
		
		if ($type == 'posts')
		{	
			if ($limit == '')
			{
				// get soft deleted posts
				$softDeletedPosts = $this->getModelFromCache('Andy_ShowDeleted_Model')->getSoftDeletedPosts();
			}
			if ($limit != '')
			{
				// get soft deleted posts
				$softDeletedPosts = $this->getModelFromCache('Andy_ShowDeleted_Model')->getSoftDeletedPostsLimit($limit);
			}
		}
		
		if ($type == 'threads')
		{	
			if ($limit == '')
			{
				// get soft deleted threads (first_post_id)
				$softDeletedPosts = $this->getModelFromCache('Andy_ShowDeleted_Model')->getSoftDeletedThreads();
			}
			if ($limit != '')
			{
				// get soft deleted threads (first_post_id)
				$softDeletedPosts = $this->getModelFromCache('Andy_ShowDeleted_Model')->getSoftDeletedThreadsLimit($limit);				
			}
		}		
		
		foreach ($softDeletedPosts as $k => $v)
		{ 
			$postId = $v['content_id'];

			$ftpHelper = $this->getHelper('ForumThreadPost');
			list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
	
			$hardDelete = $this->_input->filterSingle('hard_delete', XenForo_Input::UINT);
			$deleteType = 'hard';
	
			$this->_assertCanDeletePost($post, $thread, $forum, $deleteType);
	
			$postModel = $this->_getPostModel();
	
			$options = array(
				'reason' => ''
			);
	
			$dw = $postModel->deletePost($postId, $deleteType, $options, $forum);
	
			if ($post['post_id'] == $thread['first_post_id'])
			{
				XenForo_Model_Log::logModeratorAction(
					'thread', $thread, 'delete_' . $deleteType, array('reason' => $options['reason'])
				);
			}
			else
			{
				XenForo_Model_Log::logModeratorAction(
					'post', $post, 'delete_' . $deleteType, array('reason' => $options['reason']), $thread
				);
			}
		}
	
		// return to showdeleted
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('showdeleted/')
		);
	}
}