<?php

class Andy_ShowDeleted_ControllerPublic_ShowDeleted extends XenForo_ControllerPublic_Abstract
{	
	public function actionIndex()
	{	
		// get permission
		if (!XenForo_Visitor::getInstance()->hasPermission('showDeletedGroupID', 'showDeletedID'))
		{
			throw $this->getNoPermissionResponseException();
		}			
				
		//########################################
		// get data from model
		//########################################
		
		// get options from Admin CP -> Options -> Show Deleted -> Limit
		$limit = XenForo_Application::get('options')->showDeletedLimit;		
		
		// get posts
		$postsCount = $this->getModelFromCache('Andy_ShowDeleted_Model')->getDeletedPostsCount();
		
		// get posts
		$posts = $this->getModelFromCache('Andy_ShowDeleted_Model')->getDeletedPosts($limit);

		// get threads
		$threadsCount = $this->getModelFromCache('Andy_ShowDeleted_Model')->getDeletedThreadsCount();
		
		// get threads
		$threads = $this->getModelFromCache('Andy_ShowDeleted_Model')->getDeletedThreads($limit);	
				
		//########################################
		// display data
		//########################################	
		
		// prepare viewParams
		$viewParams = array(
			'limit' => $limit,
			'postsCount' => $postsCount,
			'posts' => $posts,
			'threadsCount' => $threadsCount,
			'threads' => $threads
		); 
		
		// send to template
		return $this->responseView('Andy_ShowDeleted_ViewPublic_ShowDeleted', 'andy_showdeleted', $viewParams);
	}
}