<?php

class Andy_ShowDeleted_Model extends XenForo_Model
{
	//########################################
	// posts
	//########################################	
	
	// deleted posts count total
	public function getDeletedPostsCount()
	{
		return $this->_getDb()->fetchOne('
		SELECT COUNT(content_type)
		FROM xf_deletion_log
		WHERE content_type = "post"
		');
	}	
	
	// show soft deleted posts	
	public function getDeletedPosts($limit)
	{
		return $this->_getDb()->fetchAll('
		SELECT xf_deletion_log.content_type, 
		xf_deletion_log.content_id AS post_id, 
		xf_deletion_log.delete_date, 
		xf_deletion_log.delete_username, 
		xf_deletion_log.delete_reason, 
		xf_node.title,
		xf_post.username
		FROM xf_deletion_log
		INNER JOIN xf_post ON xf_post.post_id = xf_deletion_log.content_id
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id
		INNER JOIN xf_node ON xf_node.node_id = xf_thread.node_id
		WHERE xf_deletion_log.content_type = "post"
		ORDER BY xf_deletion_log.delete_date DESC
		LIMIT ' . $limit . '
		');
	}
	
	// get soft deleted posts
	public function getSoftDeletedPosts()
	{
		return $this->_getDb()->fetchAll('
		SELECT content_id
		FROM xf_deletion_log
		WHERE content_type = "post"
		');
	}
	
	// get soft deleted posts with limit
	public function getSoftDeletedPostsLimit($limit)
	{
		return $this->_getDb()->fetchAll('
		SELECT content_id
		FROM xf_deletion_log
		WHERE content_type = "post"
		ORDER BY content_id ASC
		LIMIT ' . $limit . '
		');
	}
	
	//########################################
	// threads
	//########################################		
	
	// deleted threads count total
	public function getDeletedThreadsCount()
	{
		return $this->_getDb()->fetchOne('
		SELECT COUNT(content_type)
		FROM xf_deletion_log
		WHERE content_type = "thread"
		');
	}	
	
	// show soft delete threads
	public function getDeletedThreads($limit)
	{
		return $this->_getDb()->fetchAll('
		SELECT xf_deletion_log.content_type, 
		xf_deletion_log.content_id AS thread_id, 
		xf_deletion_log.delete_date, 
		xf_deletion_log.delete_username,  
		xf_deletion_log.delete_reason, 
		xf_node.title,
		xf_thread.username
		FROM xf_deletion_log
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_deletion_log.content_id
		INNER JOIN xf_node ON xf_node.node_id = xf_thread.node_id
		WHERE xf_deletion_log.content_type = "thread"
		ORDER BY xf_deletion_log.delete_date DESC
		LIMIT ' . $limit . '
		');
	}
	
	// get soft deleted threads
	public function getSoftDeletedThreads()
	{
		return $this->_getDb()->fetchAll('
		SELECT xf_thread.first_post_id AS content_id
		FROM xf_deletion_log
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_deletion_log.content_id
		WHERE xf_deletion_log.content_type = "thread"
		');
	}	
	
	// get soft deleted threads with limit
	public function getSoftDeletedThreadsLimit($limit)
	{
		return $this->_getDb()->fetchAll('
		SELECT xf_thread.first_post_id AS content_id
		FROM xf_deletion_log
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_deletion_log.content_id
		WHERE xf_deletion_log.content_type = "thread"
		ORDER BY xf_deletion_log.content_id ASC
		LIMIT ' . $limit . '
		');
	}			
}