<?php

class Andy_TimedSpoiler_ControllerPublic_Post extends XFCP_Andy_TimedSpoiler_ControllerPublic_Post
{	
	public function actionTimedSpoiler()
	{	
		// throw error if not logged in
		if (!XenForo_Visitor::getUserId())
		{
			throw $this->getNoPermissionResponseException();
		}			
		
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('timedSpoilerGroupID', 'timedSpoilerID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		// get post_id from route
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);
		
		// assert can edit
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
		$this->_assertCanEditPost($post, $thread, $forum);
		
		// get database
		$db = XenForo_Application::get('db');	
		
		// run query
		$results = $db->fetchRow("
			SELECT post_date, spoiler_date, spoiler_title, spoiler_text
			FROM xf_timed_spoiler
			WHERE post_id = ?
		",$postId);
		
		// if spoiler_date
		if ($results['spoiler_date'] != '')
		{
			// prepare var
			$var = $results['spoiler_date'] - $results['post_date'];
			
			// prepare hours
			$hours = round($var / 3600);
		}
		else
		{
			// prepare hours
			$hours = '';
		}
		
		// prepare viewParams
		$viewParams = array(
			'postId' => $postId,
			'hours' => $hours,
			'spoiler' => $results['spoiler_text']
		);
		
		// send to template
		return $this->responseView('Andy_TimedSpoiler_ViewPublic_Post','andy_timedspoiler',$viewParams);
	}
	
	public function actionTimedSpoilerSave()
	{		
		// throw error if not logged in
		if (!XenForo_Visitor::getUserId())
		{
			throw $this->getNoPermissionResponseException();
		}			
		
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('timedSpoilerGroupID', 'timedSpoilerID'))
		{
			throw $this->getNoPermissionResponseException();
		}
		
		// make sure data comes from $_POST
		$this->_assertPostOnly();		
		
		// get post_id from route
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);
		
		// get post variables
		$post = $this->getModelFromCache('XenForo_Model_Post')->getPostById($postId);		
		
		// get hours
		$hours = $this->_input->filterSingle('hours', XenForo_Input::STRING);
		
		// get spoiler
		$spoiler_text = $this->_input->filterSingle('spoiler', XenForo_Input::STRING);		
		
		// make sure hours are numeric
		if (!is_numeric($hours))
		{
			throw new XenForo_Exception(new XenForo_Phrase('timedspoiler_please_enter_hours'), true);
		}
		
		// make sure spoiler has a value
		if (!$spoiler_text)
		{
			throw new XenForo_Exception(new XenForo_Phrase('timedspoiler_please_enter_spoiler'), true);
		}
		
		//########################################
		// Remove existing timed spoiler
		// information from message if there is
		// one.
		//########################################
		
		// get database
		$db = XenForo_Application::get('db');			
		
		// run query
		$spoiler_title = $db->fetchOne("
			SELECT spoiler_title
			FROM xf_timed_spoiler
			WHERE post_id = ?
		",$postId);		
		
		// if spoiler_title exists
		if ($spoiler_title)
		{			
			// get post variables
			$post = $this->getModelFromCache('XenForo_Model_Post')->getPostById($postId);				

			// prepare newMessage
			$newMessage = str_replace($spoiler_title, '', $post['message']);

			$newMessage = rtrim($newMessage);

			// addslashes to make database safe
			$newMessage = addslashes($newMessage);		
		
			// update xf_post
			$db->query('
			UPDATE xf_post SET
				message = ?
				WHERE post_id = ?
			', array($newMessage, $postId));
		}		
		
		//########################################
		// save new timed spoiler information
		//########################################
		
		// addslashes to make database safe
		$spoiler_text = addslashes($spoiler_text);		
		
		// prepare post_date
		$post_date = $post['post_date'];
		
		// delete current post_id
		$db->query('
			DELETE FROM xf_timed_spoiler
			WHERE post_id = ' . $postId . '
		');
		
		// prepare spoiler_date
		$spoiler_date = $post_date + ($hours * 3600);	
		
		// calculate spoiler_date to the nearest 10 minute mark
		$spoiler_date = ceil($spoiler_date / 600) * 600;			
		
		// prepare spoiler_title
		$spoiler_title = '[' . new XenForo_Phrase('timedspoiler_spoiler_will_show') . ' ' . gmdate("F jS, Y, g:i a", $spoiler_date + XenForo_Locale::getTimeZoneOffset()) . ']';		

		// insert new data
		$db->query("
			INSERT INTO xf_timed_spoiler
				(post_id, post_date, spoiler_date, spoiler_title, spoiler_text)
			VALUES
				('$postId', '$post_date', '$spoiler_date', '$spoiler_title', '$spoiler_text')
		");
		
		//########################################
		// update message
		//########################################
		
		// run query
		$message = $db->fetchOne("
		SELECT message 
		FROM xf_post
		WHERE post_id = ?
		", $postId);		
		
		// create new message
		$newMessage = $message . '

' . $spoiler_title;	
		
		// addslashes to make database safe
		$newMessage = addslashes($newMessage);		
	
		// update xf_post
		$db->query('
		UPDATE xf_post SET
			message = ?
			WHERE post_id = ?
		', array($newMessage, $postId));
		
		//#####################################
		// begin update search
		//#####################################		
		
		// delete xf_bb_code_parse_cache
		$db->query('
			DELETE FROM xf_bb_code_parse_cache
			WHERE content_id = ?
		', $postId);	
		
		//########################################
		// this query is used to update 
		// xf_search_index and ElasticSearch index
		
		// run query
		$data = $db->fetchRow("
		SELECT xf_thread.node_id, 
		xf_thread.thread_id, 
		xf_thread.title, 
		xf_post.message, 
		xf_post.post_date, 
		xf_post.user_id
		FROM xf_post
		INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
		WHERE xf_post.post_id = ?
		", $postId);	
		
		// addslashes to make database safe
		$data['message'] = addslashes($data['message']);						
		
		//#####################################
		// update xf_search_index
		//#####################################				

		// if ElasticSearch is NOT enabled
		if (!XenForo_Application::get('options')->enableElasticsearch)
		{			
			// run query
			$db->query('
				UPDATE xf_search_index SET
					message = "' . $data['message'] . '"
				WHERE content_type = "post"
				AND content_id = ?
			', $postId);
		}
		
		//#####################################
		// update ElasticSearch post index
		//#####################################
		
		// if ElasticSearch is enabled
		if (XenForo_Application::get('options')->enableElasticsearch)
		{				
			// get ElasticSearch index name
			$indexName = XenES_Api::getInstance()->getIndex();		
			
			// define variables
			$contentType = 'post';
			$contentId = $postId;
			
			// define record data
			$record = array(
				'node' => $data['node_id'],
				'thread' => $data['thread_id'],
				'title' => $data['title'], 
				'message' => $data['message'],
				'date' => $data['post_date'],
				'user' => $data['user_id'],
				'discussion_id' => $postId
			);

			// update ElasticSearch index
			XenES_Api::index($indexName, $contentType, $contentId, $record);
		}						
		
		// prepare variables for redirect
		$post['post_id'] = $postId;
		$changesSaved = new XenForo_Phrase('timedspoiler_changes_saved');
		
		// return with response redirect
		return $this->responseRedirect(
		XenForo_ControllerResponse_Redirect::SUCCESS,
		XenForo_Link::buildPublicLink('posts', $post), $changesSaved);
	}
	
	public function actionTimedSpoilerDelete()
	{
		// get post_id from route
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::UINT);
		
		// assert can edit
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
		$this->_assertCanEditPost($post, $thread, $forum);
		
		// get database
		$db = XenForo_Application::get('db');			
		
		// delete row
		$db->query('
			DELETE FROM xf_timed_spoiler
			WHERE post_id = ' . $postId . '
		');
		
		// prepare variable for redirect
		$post['post_id'] = $postId;
		
		// redirect
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('posts', $post)
		);		
	}	
}