<?php

class Andy_TimedSpoiler_CronEntry_TimedSpoiler
{
	public static function runTimedSpoiler()
	{
		// get database
		$db = XenForo_Application::get('db');
		
		$dateline = time();
		
		// run query
		$results = $db->fetchAll("
			SELECT xf_timed_spoiler.post_id AS postId, xf_timed_spoiler.spoiler_title, xf_timed_spoiler.spoiler_text, xf_post.message
			FROM xf_timed_spoiler
			INNER JOIN xf_post ON xf_post.post_id = xf_timed_spoiler.post_id
			WHERE xf_timed_spoiler.spoiler_date < $dateline
		");
		
		// run foreach
		foreach ($results as $k => $v)
		{
			// replace spoiler_title with spoiler_text
			$newMessage = str_replace($v['spoiler_title'], '[SPOILER]' . $v['spoiler_text'] . '[/SPOILER]', $v['message']);
			
			// prepare postId
			$postId = $v['postId'];	

			// update xf_post.message
			$db->query('
			UPDATE xf_post SET
				message = ?
				WHERE post_id = ?
			', array($newMessage, $postId));	
			
			// delete xf_timed_spoiler row for this postId
			$db->query('
				DELETE FROM xf_timed_spoiler
				WHERE post_id = ' . $postId . '
			');
			
			//#####################################
			// begin update search
			//#####################################		
			
			// delete xf_bb_code_parse_cache
			$db->query('
				DELETE FROM xf_bb_code_parse_cache
				WHERE content_id = ?
			', $postId);	
			
			// this query is used to update 
			// xf_search_index and ElasticSearch index
			
			// run query
			$data = $db->fetchRow("
			SELECT xf_thread.node_id, 
			xf_thread.thread_id, 
			xf_thread.title, 
			xf_post.message, 
			xf_post.post_date, 
			xf_post.user_id
			FROM xf_post
			INNER JOIN xf_thread ON xf_thread.thread_id = xf_post.thread_id 
			WHERE xf_post.post_id = ?
			", $postId);	
			
			// addslashes to make database safe
			$data['message'] = addslashes($data['message']);						
			
			//#####################################
			// update xf_search_index
			//#####################################				
	
			// if ElasticSearch is NOT enabled
			if (!XenForo_Application::get('options')->enableElasticsearch)
			{			
				// run query
				$db->query('
					UPDATE xf_search_index SET
						message = "' . $data['message'] . '"
					WHERE content_type = "post"
					AND content_id = ?
				', $postId);
			}
			
			//#####################################
			// update ElasticSearch post index
			//#####################################
			
			// if ElasticSearch is enabled
			if (XenForo_Application::get('options')->enableElasticsearch)
			{				
				// get ElasticSearch index name
				$indexName = XenES_Api::getInstance()->getIndex();		
				
				// define variables
				$contentType = 'post';
				$contentId = $currentPostId;
				
				// define record data
				$record = array(
					'node' => $data['node_id'],
					'thread' => $data['thread_id'],
					'title' => $data['title'], 
					'message' => $data['message'],
					'date' => $data['post_date'],
					'user' => $data['user_id'],
					'discussion_id' => $currentPostId
				);
	
				// update ElasticSearch index
				XenES_Api::index($indexName, $contentType, $contentId, $record);
			}
		}
		
		//#####################################
		// Delete orpahned rows. This can
		// occure when a post with a timed 
		// spoiler is deleted.
		//#####################################	
		
		// prepare variable
		$dateline = time() - 3600;
		
		// run query
		$db->query('
			DELETE FROM xf_timed_spoiler
			WHERE spoiler_date < ' . $dateline . '
		');		
	}
}