<?php

class Andy_UserLanguage_ControllerPublic_UserLanguage extends XenForo_ControllerPublic_Abstract
{	
	public function actionIndex()
	{				
		// get user group permission
		if (!XenForo_Visitor::getInstance()->hasPermission('userLanguageGroupID', 'userLanguageID'))
		{
			throw $this->getNoPermissionResponseException();
		}				

		// get results	
		$results = $this->getModelFromCache('Andy_UserLanguage_Model')->getResults();
		
		// get total
		$total = count($results);	
		
		// get options from Admin CP -> Options -> Accept Language -> Hours
		$hours = XenForo_Application::get('options')->userLanguageHours;
		
		// prepare viewParams
		$viewParams = array(
			'total' => $total,
			'hours' => $hours,
			'results' => $results
		);		
		
		// send to template
		return $this->responseView('Andy_UserLanguage_ViewPublic_UserLanguage', 'andy_userlanguage', $viewParams);
	}
}