<?php

class BannedAvatar_Listener
{
	public static function extendWaindigoNodeModel($class, array &$extend)
	{
		$extend[] = 'BannedAvatar_Waindigo_LastPostAvatar_Model_Node';
	}

	public static function extendWaindigoThreadModel($class, array &$extend)
	{
		$extend[] = 'BannedAvatar_Waindigo_LastPostAvatar_Model_Thread';
	}

    public static function init(XenForo_Dependencies_Abstract $dependencies, array $data)
    {
        XenForo_Template_Helper_Core::$helperCallbacks['avatar']
            = array('BannedAvatar_Listener', 'helperAvatarUrl');
    }

    public static function helperAvatarUrl($user, $size, $forceType = null, $canonical = false)
    {
        if (!is_array($user))
        {
            $user = array();
        }

        if ($forceType)
        {
            switch ($forceType)
            {
                case 'default':
                case 'custom':
                    break;

                default:
                    $forceType = null;
                    break;
            }
        }

        $url = self::getAvatarUrl($user, $size, $forceType);

        if ($canonical)
        {
            $url = XenForo_Link::convertUriToAbsoluteUri($url, true);
        }

        return htmlspecialchars($url);
    }

    public static function getAvatarUrl(array $user, $size, $forceType = '')
    {
        if (!empty($user['user_id']) && $forceType != 'default')
        {
            if ($user['gravatar'] && $forceType != 'custom')
            {
                return self::_getGravatarUrl($user, $size);
            }
            else if (!empty($user['avatar_date']))
            {
                return self::_getCustomAvatarUrl($user, $size);
            }
        }

        return self::_getDefaultAvatarUrl($user, $size);
    }

    protected static function _getDefaultAvatarUrl(array $user, $size)
    {
        if (!isset($user['gender']))
        {
            $user['gender'] = '';
        }

        switch ($user['gender'])
        {
            case 'male':
            case 'female':
                $gender = $user['gender'] . '_';
                break;

            default:
                $gender = '';
                break;
        }

        if (!$imagePath = XenForo_Template_Helper_Core::styleProperty('imagePath'))
        {
            $imagePath = 'styles/default';
        }

        if (!empty($user['is_banned']))
        {
			// Quick fix for odd avatar position:
			if (!empty($user['avatar_crop_x']) || !empty($user['avatar_crop_y']) || ($user['avatar_height'] != 192 || $user['avatar_width'] != 192))
			{
				$userData = array(
					'avatar_date' => XenForo_Application::$time,
					'avatar_height' => 192,
					'avatar_width' => 192
				);

				$cropArea = array(
					'avatar_crop_x' => 0,
					'avatar_crop_y' => 0
				);

				$db = XenForo_Application::getDb();

				$db->update('xf_user_profile', $cropArea, 'user_id = ' . $user['user_id']);
				$db->update('xf_user', $userData, 'user_id = ' . $user['user_id']);
			}

            return "{$imagePath}/xenforo/avatars/avatar_banned_{$size}.png";
        }
        else
        {
            return "{$imagePath}/xenforo/avatars/avatar_{$gender}{$size}.png";
        }
    }

    protected static function _getCustomAvatarUrl(array $user, $size)
    {
        if (!empty($user['is_banned']))
        {
			// Quick fix for odd avatar position:
			if (!empty($user['avatar_crop_x']) || !empty($user['avatar_crop_y']) || ($user['avatar_height'] != 192 || $user['avatar_width'] != 192))
			{
				$userData = array(
					'avatar_date' => XenForo_Application::$time,
					'avatar_height' => 192,
					'avatar_width' => 192
				);

				$cropArea = array(
					'avatar_crop_x' => 0,
					'avatar_crop_y' => 0
				);

				$db = XenForo_Application::getDb();

				$db->update('xf_user_profile', $cropArea, 'user_id = ' . $user['user_id']);
				$db->update('xf_user', $userData, 'user_id = ' . $user['user_id']);
			}

            if (!$imagePath = XenForo_Template_Helper_Core::styleProperty('imagePath'))
            {
                $imagePath = 'styles/default';
            }
            return "{$imagePath}/xenforo/avatars/avatar_banned_{$size}.png";
        }
        else
        {
            $group = floor($user['user_id'] / 1000);
            return XenForo_Application::$externalDataUrl . "/avatars/$size/$group/$user[user_id].jpg?$user[avatar_date]";
        }
    }
    
    protected static function _getGravatarUrl(array $user, $size, $default = '')
    {
    	$md5 = md5($user['gravatar']);
    
    	if ($default === '')
    	{
    		$default = '&d=' . urlencode(XenForo_Application::get('options')->boardUrl . '/' . self::_getDefaultAvatarUrl($user, $size));
    	}
    	else if (!empty($default))
    	{
    		$default = '&d=' . urlencode($default);
    	}
    	
    	$sizeCode = $size;
    
    	if (is_string($size))
    	{
    		$size = XenForo_Model_Avatar::getSizeFromCode($size);
    	}

        if (!empty($user['is_banned']))
        {
			// Quick fix for odd avatar position:
			if (!empty($user['avatar_crop_x']) || !empty($user['avatar_crop_y']) || ($user['avatar_height'] != 192 || $user['avatar_width'] != 192))
			{
				$userData = array(
					'avatar_date' => XenForo_Application::$time,
					'avatar_height' => 192,
					'avatar_width' => 192
				);

				$cropArea = array(
					'avatar_crop_x' => 0,
					'avatar_crop_y' => 0
				);

				$db = XenForo_Application::getDb();

				$db->update('xf_user_profile', $cropArea, 'user_id = ' . $user['user_id']);
				$db->update('xf_user', $userData, 'user_id = ' . $user['user_id']);
			}

            if (!$imagePath = XenForo_Template_Helper_Core::styleProperty('imagePath'))
            {
                $imagePath = 'styles/default';
            }
            return "{$imagePath}/xenforo/avatars/avatar_banned_{$sizeCode}.png";
        }
        else
        {
    		return (XenForo_Application::$secure ? 'https://secure' : 'http://www')
    		. ".gravatar.com/avatar/{$md5}.jpg?s={$size}{$default}";			
        }
    }
    


}
?>