<?php

class BannedAvatar_Waindigo_LastPostAvatar_Model_Thread extends XFCP_BannedAvatar_Waindigo_LastPostAvatar_Model_Thread
{
	/**
	 * @see XenForo_Model_Thread::prepareThreadFetchOptions()
	 */
	public function prepareThreadFetchOptions(array $fetchOptions)
	{
		$threadFetchOptions = parent::prepareThreadFetchOptions($fetchOptions);

		if ((!empty($fetchOptions['join']) && $fetchOptions['join'] & self::FETCH_FIRSTPOST)
			|| (!empty($fetchOptions['join_waindigo']) && $fetchOptions['join_waindigo'] & Waindigo_LastPostAvatar_Extend_XenForo_Model_Thread::FETCH_WAINDIGO_LASTPOST_AVATAR))
		{
			$threadFetchOptions['selectFields'] .= ',
				last_post_user.is_banned AS last_post_user_is_banned';
		}

		return array(
			'selectFields' => $threadFetchOptions['selectFields'],
			'joinTables' => $threadFetchOptions['joinTables'],
			'orderClause' => $threadFetchOptions['orderClause']
		);
	}

	public function prepareThread(array $thread, array $forum, array $nodePermissions = null, array $viewingUser = null)
	{
		$thread = parent::prepareThread($thread, $forum, $nodePermissions, $viewingUser);

		if (isset($thread['last_post_user_is_banned']))
		{
			$thread['lastPostInfo']['is_banned'] = $thread['last_post_user_is_banned'];
		}

		return $thread;
	} /* END prepareThread */
}