<?php

class BestAnswer_Installer
{
	public static function install($existingAddOn, $addOnData)
	{
		$db = XenForo_Application::get('db');
		
		if (!$db->fetchRow("SHOW columns FROM xf_forum WHERE Field = 'allow_best_answer'"))
		{
			$db->query("ALTER TABLE xf_forum ADD COLUMN allow_best_answer TINYINT UNSIGNED NOT NULL DEFAULT 1");
		}
		
		if (!$db->fetchRow("SHOW columns FROM xf_thread WHERE Field = 'best_answer_id'"))
		{
			$db->query("ALTER TABLE xf_thread ADD COLUMN best_answer_id INT(10) UNSIGNED NOT NULL DEFAULT '0'");
		}
		
		if (!$db->fetchRow("SHOW columns FROM xf_user WHERE Field = 'best_answer_count'"))
		{
			$db->query("ALTER TABLE xf_user ADD COLUMN best_answer_count INT(10) UNSIGNED NOT NULL DEFAULT '0'");
		}
		
		$db->query("
			CREATE TABLE IF NOT EXISTS xf_best_answer_vote (
				vote_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
				thread_id INT(10) UNSIGNED NOT NULL,
				post_id INT(10) UNSIGNED NOT NULL,
				user_id INT(10) UNSIGNED NOT NULL,
				vote_date INT(10) UNSIGNED NOT NULL,
				PRIMARY KEY (vote_id),
				UNIQUE KEY user_thread (thread_id,user_id)
			)
		");
		
		if ($existingAddOn['version_id'] < 5)
		{
			$threads = $db->fetchAll('
				SELECT thread.thread_id
				FROM xf_thread AS thread
				WHERE thread.best_answer_id != 0
			');
			
			foreach ($threads AS $thread)
			{
				$threadDw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
				$threadDw->setExistingData($thread['thread_id']);
				$threadDw->rebuildDiscussion();
				$threadDw->save();
			}
		}
	}
	
	public static function uninstall()
	{
		$db = XenForo_Application::get('db');
		
		if ($db->fetchRow("SHOW columns FROM xf_forum WHERE Field = 'allow_best_answer'"))
		{
			$db->query("ALTER TABLE xf_thread DROP allow_best_answer");
		}
		
		if ($db->fetchRow("SHOW columns FROM xf_thread WHERE Field = 'best_answer_id'"))
		{
			$db->query("ALTER TABLE xf_thread DROP best_answer_id");
		}
		
		if ($db->fetchRow("SHOW columns FROM xf_user WHERE Field = 'best_answer_count'"))
		{
			$db->query("ALTER TABLE xf_user DROP best_answer_count");
		}
		
		$db->query("DROP TABLE IF EXISTS xf_best_answer_vote");
	}
}