<?php

class BestAnswer_Model_Post extends XFCP_BestAnswer_Model_Post
{
	public function preparePost(array $post, array $thread, array $forum, array $nodePermissions = null, array $viewingUser = null)
	{
		$response = parent::preparePost($post, $thread, $forum, $nodePermissions, $viewingUser);
		
		$response['showBestAnswer'] = $this->getModelFromCache('BestAnswer_Model_BestAnswer')->canMarkAsBestAnswer($post, $thread, $forum);
		
		if ($thread['best_answer_id'] == $post['post_id']/* && !empty($post['dupe'])*/)
		{
			$response['isBestAnswer'] = true;
		}
		
		return $response;
	}
	
	public function getPostsInThread($threadId, array $fetchOptions = array())
	{
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
		$stateLimit = $this->prepareStateLimitFromConditions($fetchOptions, 'post');
		$joinOptions = $this->preparePostJoinOptions($fetchOptions);
		
		$params = array($threadId);
		if ($limitOptions['offset'] == 0 && !empty($fetchOptions['bestAnswerId']))
		{
			$params[] = $fetchOptions['bestAnswerId'];
		}
		
		$posts = $this->fetchAllKeyed('
			SELECT post.*
				' . $joinOptions['selectFields'] . '
			FROM xf_post AS post
			' . $joinOptions['joinTables'] . '
			WHERE (
					(post.thread_id = ? ' . $this->addPositionLimit('post', $limitOptions['limit'], $limitOptions['offset']) . ')
					' . ($limitOptions['offset'] == 0 && !empty($fetchOptions['bestAnswerId']) ? 'OR post.post_id = ?' : '') . '
				)
				AND (' . $stateLimit . ')
			ORDER BY post.position ASC, post.post_date ASC
		', 'post_id', $params);
		
		if ($limitOptions['offset'] == 0 && !empty($fetchOptions['bestAnswerId']) && $posts[$fetchOptions['bestAnswerId']]['position'] != 1)
		{
			$firstPost = reset($posts);
			$firstPostKey = key($firstPost);
			
			$bestAnswer = $posts[$fetchOptions['bestAnswerId']];
			$bestAnswer['dupe'] = true;
			
			$sorted = array(key($posts) => $firstPost, 0 => $bestAnswer);
			unset($posts[$firstPostKey]);
			
			if (!($posts[$fetchOptions['bestAnswerId']]['position'] >= $limitOptions['offset'] && $posts[$fetchOptions['bestAnswerId']]['position'] <= $limitOptions['limit'] + $limitOptions['offset']))
			{
				unset($posts[$fetchOptions['bestAnswerId']]);
			}
			$posts = $sorted + $posts;
		}
		
		return $posts;
	}
}