<?php

class Borbole_RecentPosts_RecentPosts extends XenForo_Model
{
    public function getrecentPosts($limit)
    {
	   
	   $postModel = $this->getModelFromCache('XenForo_Model_Post');
	   $options = XenForo_Application::get('options');
       $limit = $options->recentpostsnum;
	   
	   //Exlude forums from where you don't want to show threads in the sidebar
	   $exclpostforums = "";
	   
       if (XenForo_Application::get('options')->exclpostforums)
       {
            $exclpostforums = XenForo_Application::get('options')->exclpostforums;
            $exclpostforums = "AND thread.node_id NOT IN ($exclpostforums)";
       }
	   
            $recentPosts = $this->limitQueryResults("
            SELECT post.*, thread.*, user.*
            FROM xf_post AS post
            LEFT JOIN xf_thread AS thread ON (thread.thread_id = post.thread_id)
            LEFT JOIN xf_user AS user ON (user.user_id = post.user_id)
            WHERE NOT ISNULL(thread.thread_id) $exclpostforums
			AND post.message_state = 'visible'
			AND user.is_banned = 0
			GROUP BY post.post_id
            ORDER BY post.post_date DESC
           ",$limit);

        $postId = $this->_getDb()->fetchCol($recentPosts);

        $postResults = $this->getModelFromCache('XenForo_Model_Post')->getPostsByIds($postId, array(
                       'join' => XenForo_Model_Post::FETCH_THREAD | XenForo_Model_Post::FETCH_USER ));
    
        $posts = array();
		
        foreach ($postResults AS $post)
        {
            if ($postModel->canViewPost($post, $post, $post))
			{
                $posts["$post[post_id].$post[post_date]"] = $post;
			}	
        }
		
        krsort($posts);
        return $posts;
    }
}
