<?php
class Brivium_AddonInstallLog_ControllerAdmin_AddOn extends XFCP_Brivium_AddonInstallLog_ControllerAdmin_AddOn {

	public function actionAddonInstallLog(){
		$input = $this->_getFilterParams();
		
		$dateInput = $this->_input->filter(array(
				'start' => XenForo_Input::DATE_TIME,
				'end' => array(XenForo_Input::DATE_TIME, 'dayEnd' => true),
		));
		
		if(empty($dateInput['end'])){
			$dateInput['end']=XenForo_Application::$time;
		}
		
		$pageNavParams = array();
		if ($input['start'])
		{
			$pageNavParams['start'] = $input['start'];
		}
		if ($input['end'])
		{
			$pageNavParams['end'] = $input['end'];
		}
		if ($input['username'])
		{
			$pageNavParams['username'] = $input['username'];
		}
		
		$ipAddress = null;
		if (!empty($input['ip_address']))
		{
			$ipAddress = ip2long($input['ip_address']);
			$pageNavParams['ip_address'] = $ipAddress;
		}
		if (!empty($input['status']))
		{
			$pageNavParams['status'] = $input['status']==1?1:0;
		}
		if (!empty($input['controls']))
		{
			$pageNavParams['controls'] = $input['controls'];
		}
		
		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$addOnsPerPage = XenForo_Application::getOptions()->BRAIL_addOnsLogPerPage;
		
		
		//get informations addon-log
		$conditions = array(
				'username' 		=> $input['username'],
				'request_date'	=>array('>=<',$dateInput['start'], $dateInput['end']),
				'ip_address'	=>$ipAddress,
				'controls'		=>$input['controls']
		);
		if(isset($pageNavParams['status'])){
			$conditions['status'] = $pageNavParams['status'];
		}
		
		$fetchOptions = array(
				'join' => XenForo_Model_Post::FETCH_USER,
				'page' => $page,
				'perPage' => $addOnsPerPage,
				'order' => 'request_date',
		);
		
		$addOnLogModel = $this->getModelFromCache('Brivium_AddonInstallLog_Model_AddOnLogs');
		
		$addOnLogs = $addOnLogModel->getListLog($conditions,$fetchOptions);
		foreach ($addOnLogs AS &$val){
			if(!empty($val['ip_address'])){
				$val['ip_address'] = long2ip($val['ip_address']);
			}
		}
		$total =  $addOnLogModel->countAddOnLog($conditions);
		
		$viewParams = array(
				'addOns'		=> $addOnLogs,
				
				'username' => $input['username'],
				'ip_address' => !empty($input['ip_address'])?$input['ip_address']:null,
				'status' => $input['status'],
				'start' => $input['start'],
				'end' => $input['end'],
				'datePresets' 	=> XenForo_Helper_Date::getDatePresets(),
				
				'controls' => $input['controls'],

				'startOffset' => ($page - 1) * $addOnsPerPage + 1,
				'endOffset' => ($page - 1) * $addOnsPerPage + count($addOnLogs),
				
				'total' => $total,
				
				'page' => $page,
				'perPage' => $addOnsPerPage,
				'pageNavParams' => $pageNavParams,
		);
		return $this->responseView('XenForo_ViewAdmin_Base', 'BRAIL_addon_log_lists', $viewParams);
	}
	
	
	protected function _getFilterParams()
	{
		return $this->_input->filter(array(
				'username' 	=> XenForo_Input::STRING,
				'ip_address'=> XenForo_Input::STRING,
				'controls'	=> XenForo_Input::STRING,
				'start' 	=> XenForo_Input::STRING,
				'end' 		=> XenForo_Input::STRING,
				'status' 	=> XenForo_Input::UINT,
		));
	}
}