<?php
class Brivium_AddonInstallLog_DataWriter_AdminLog extends XenForo_DataWriter{
	
	protected function _getFields()
	{
		return array(
				'xf_brivium_addon_install_log' => array(
						'log_id'       				=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
						'addon_id'                  => array('type' => self::TYPE_STRING,  'maxLength' => 25,'default' => ''),
						'title'                     => array('type' => self::TYPE_STRING,  'maxLength' => 75, 'default' => ''),
						'version_string'            => array('type' => self::TYPE_STRING,  'maxLength' => 30, 'default' => ''),
						'version_id'                => array('type' => self::TYPE_UINT,    'default' => 0),
						'install_callback_class'    => array('type' => self::TYPE_STRING,  'maxLength' => 75, 'default' => ''),
						'install_callback_method'   => array('type' => self::TYPE_STRING,  'maxLength' => 75, 'default' => ''),
						'uninstall_callback_class'  => array('type' => self::TYPE_STRING,  'maxLength' => 75, 'default' => ''),
						'uninstall_callback_method' => array('type' => self::TYPE_STRING,  'maxLength' => 75, 'default' => ''),
						'url'                       => array('type' => self::TYPE_STRING,  'maxLength' => 100, 'default' => ''),
						'ip_address'                => array('type' => self::TYPE_UINT,    'default' => 0),
						'user_id'                	=> array('type' => self::TYPE_UINT,    'default' => 0),
						'username'                	=> array('type' => self::TYPE_STRING,  'maxLength' => 50, 'default' => ''),
						'request_date'              => array('type' => self::TYPE_UINT,    'default' => 0),
						'controls'                	=> array('type' => self::TYPE_STRING,  'maxLength' => 100, 'default' => ''),
						'status'                	=> array('type' => self::TYPE_BOOLEAN,    'default' => 0),
				)
		);
	}
	
	
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'log_id'))
		{
			return false;
		}
		return array('xf_brivium_addon_install_log' => $this->_getAddOnInstallLogModel()->getAddOnInstallLogById($id));
	}
	
	/**
	 * Gets SQL condition to update the existing record.
	 *
	 * @return string
	 */
	protected function _getUpdateCondition($tableName)
	{
		return 'log_id = ' . $this->_db->quote($this->getExisting('log_id'));
	}
	
	/**
	 * Verifies that the add-on ID is valid.
	 *
	 * @param string $addOnId
	 *
	 * @return boolean
	 */
	protected function _verifyAddOnId(&$addOnId)
	{
	}
	
	/**
	 * Pre-save handling.
	 */
	protected function _preSave()
	{
	}
	
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
	}
	
	/**
	 * Post-delete handling.
	 */
	protected function _preDelete()
	{
	}
	
	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
	}
	
	/**
	 * Gets the add-on model object.
	 *
	 * @return XenForo_Model_AddOn
	 */
	protected function _getAddOnModel()
	{
	}
	
	protected function _getAddOnInstallLogModel(){
		return $this->getModelFromCache('Brivium_AddonInstallLog_Model_AddOn');
	}
}