<?php
class Brivium_AddonInstallLog_Model_AddOn extends XFCP_Brivium_AddonInstallLog_Model_AddOn{
	
	public function installAddOnXml(SimpleXMLElement $xml, $upgradeAddOnId = false){
		if ($xml->getName() == 'addon'){
			$logId = self::brInsertAddOnData($xml,$upgradeAddOnId);
			
			$flag = parent::installAddOnXml($xml,$upgradeAddOnId);
			
			if($flag){
				self::brUpdateAddOnData($logId);
			}
			return $flag;
		}else{
			return parent::installAddOnXml($xml,$upgradeAddOnId);
		}
	}
	
	
	private function brInsertAddOnData(SimpleXMLElement $xml, $upgradeAddOnId = FALSE ){
	
		//Get IP address
		$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);
	
		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}
		else
		{
			$ipAddress = 0;
		}
	
		$controls = $upgradeAddOnId?'upgrade':'install';
		$visitor = XenForo_Visitor::getInstance();
	
		$addOnData = array(
				'addon_id' 					=> (string)$xml['addon_id'],
				'title' 					=> (string)$xml['title'],
				'version_string' 			=> (string)$xml['version_string'],
				'version_id'		 		=> (int)$xml['version_id'],
				'install_callback_class' 	=> (string)$xml['install_callback_class'],
				'install_callback_method' 	=> (string)$xml['install_callback_method'],
				'uninstall_callback_class' 	=> (string)$xml['uninstall_callback_class'],
				'uninstall_callback_method' => (string)$xml['uninstall_callback_method'],
				'url' 						=> (string)$xml['url'],
				'ip_address' 				=> $ipAddress,
				'user_id' 					=> $visitor['user_id'],
				'username' 					=> $visitor['username'],
				'request_date'				=> XenForo_Application::$time,
				'controls'					=> $controls,
		);
	
		$addOnDw = XenForo_DataWriter::create('Brivium_AddonInstallLog_DataWriter_AdminLog');
		$addOnDw->bulkSet($addOnData);
	
		$addOnDw->save();
	
		return $addOnDw->get('log_id');
	}
	
	private function brUpdateAddOnData($logId){
		$addOnData = array('status'=>1);
	
		$addOnDw = XenForo_DataWriter::create('Brivium_AddonInstallLog_DataWriter_AdminLog');
		$addOnDw->setExistingData($logId);
		$addOnDw->bulkSet($addOnData);
		$addOnDw->save();
	}
	
	public function getAddOnInstallLogById($logId =  0){
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_brivium_addon_install_log
			WHERE  log_id = ?
		', array( $logId));
	}
	
	public function brInformationAddOnDelete($addOnId = ''){
		
		$dataAddOn = $this->brGetAddOnByAddOnId($addOnId);
		
		if(!empty($dataAddOn)){
			//Get IP address
			$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : false);
			
			if (is_string($ipAddress) && strpos($ipAddress, '.'))
			{
				$ipAddress = ip2long($ipAddress);
			}
			else
			{
				$ipAddress = 0;
			}
			
			$visitor = XenForo_Visitor::getInstance();
			
			unset($dataAddOn['log_id']);
			$dataAddOn['ip_address']=$ipAddress;
			$dataAddOn['user_id']	=$visitor['user_id'];
			$dataAddOn['username']	=$visitor['username'];
			$dataAddOn['request_date']=XenForo_Application::$time;
			$dataAddOn['controls']='uninstall';
			$dataAddOn['status']=1;
			
			$addOnDw = XenForo_DataWriter::create('Brivium_AddonInstallLog_DataWriter_AdminLog');
			$addOnDw->bulkSet($dataAddOn);
			$addOnDw->save();
		}
	}
	
	public function brGetAddOnByAddOnId($addOnId = ''){
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_brivium_addon_install_log
			WHERE  addon_id = ?
			ORDER BY  request_date DESC
			LIMIT 0,1
		', array( $addOnId));
	}

}