<?php
class Brivium_AddonInstallLog_Model_AddOnLogs extends XenForo_Model{
	
	const FETCH_USER = 0x01;
	const FETCH_AVATAR = 0x02;
	
	public function getListLog(array $conditions, array $fetchOptions = array())
	{
		$whereConditions = $this->prepareAddOnConditions($conditions, $fetchOptions);
		
		$sqlClauses = $this->prepareAddOnFetchOptions($fetchOptions);

		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
	
		return $this->fetchAllKeyed($this->limitQueryResults(
				'
				SELECT brivium_addon_install_log.*
					' . $sqlClauses['selectFields'] . '
				FROM xf_brivium_addon_install_log AS brivium_addon_install_log
					' . $sqlClauses['joinTables'] . '
				WHERE ' . $whereConditions . '
				' . $sqlClauses['orderClause'] . '
			', $limitOptions['limit'], $limitOptions['offset']
		), 'log_id');
	}
	
	public function countAddOnLog(array $conditions)
	{
		$fetchOptions = array();
		$whereConditions = $this->prepareAddOnConditions($conditions, $fetchOptions);
	
		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM xf_brivium_addon_install_log AS brivium_addon_install_log
			WHERE ' . $whereConditions . '
		');
	}
	
	public function prepareAddOnConditions(array $conditions, array &$fetchOptions)
	{
		$sqlConditions = array();
		$db = $this->_getDb();
	
	
		
		if (!empty($conditions['user_id']))
		{
			$sqlConditions[] = 'brivium_addon_install_log.user_id = ' . $db->quote($conditions['user_id']);
		}
		
		if (!empty($conditions['username']))
		{
			$sqlConditions[] = 'brivium_addon_install_log.username = ' . $db->quote($conditions['username']);
		}
		
		if (!empty($conditions['ip_address']))
		{
			$sqlConditions[] = 'brivium_addon_install_log.ip_address = ' . $db->quote($conditions['ip_address']);
		}
		
		if (!empty($conditions['controls']))
		{
			$sqlConditions[] = 'brivium_addon_install_log.controls = ' . $db->quote($conditions['controls']);
		}
		
		if (!empty($conditions['request_date']) && is_array($conditions['request_date']))
		{
			$sqlConditions[] = $this->getCutOffCondition("brivium_addon_install_log.request_date", $conditions['request_date']);
		}
		
		if (isset($conditions['status']))
		{
			$sqlConditions[] = 'brivium_addon_install_log.status = ' . ($conditions['status'] ? 1 : 0);
		}
	
		return $this->getConditionsForClause($sqlConditions);
	}
	
	
	public function prepareAddOnFetchOptions(array $fetchOptions)
	{
		$selectFields = '';
		$joinTables = '';
		$orderBy = '';
	
		if (!empty($fetchOptions['order']))
		{
			$orderBySecondary = '';
	
			switch ($fetchOptions['order'])
			{
				case 'request_date':
				default:
					$orderBy = 'brivium_addon_install_log.request_date';
			}
			if (!isset($fetchOptions['orderDirection']) || $fetchOptions['orderDirection'] == 'desc')
			{
				$orderBy .= ' DESC';
			}
			else
			{
				$orderBy .= ' ASC';
			}
	
			$orderBy .= $orderBySecondary;
		}
	
		if (!empty($fetchOptions['join']))
		{
			if ($fetchOptions['join'] & self::FETCH_USER)
			{
				$selectFields .= ',
					user.avatar_date, IF(user.username IS NULL, brivium_addon_install_log.username, user.username) AS username';
				$joinTables .= '
					LEFT JOIN xf_user AS user ON
						(user.user_id = brivium_addon_install_log.user_id)';
			}
			else if ($fetchOptions['join'] & self::FETCH_AVATAR)
			{
				$selectFields .= ',
					user.gender, user.avatar_date, user.gravatar';
				$joinTables .= '
					LEFT JOIN xf_user AS user ON
						(user.user_id = brivium_addon_install_log.user_id)';
			}
	
		}
		return array(
				'selectFields' => $selectFields,
				'joinTables'   => $joinTables,
				'orderClause'  => ($orderBy ? "ORDER BY $orderBy" : '')
		);
	}
	
}