<?php
class Brivium_AdvancedRules_ControllerPublic_Conversation extends XFCP_Brivium_AdvancedRules_ControllerPublic_Conversation
{

	public function actionAdd()
	{
		$response = parent::actionAdd();

		if (!$this->_getConversationModel()->canStartConversations($errorPhraseKey))
		{
			throw $this->getErrorOrNoPermissionResponseException($errorPhraseKey);
		}

		$options = XenForo_Application::get('options');
		$visitor = XenForo_Visitor::getInstance();

		$userGroups = $options->AdvancedRules_userGroup;
		$setup = $options->AdvancedRules_setup;

		if ($visitor['user_id'] > 0)
		{
			if(!in_array($visitor['user_group_id'], $userGroups) && $setup['startConversation'] && !$visitor['advanced_rules'])
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
					XenForo_Link::buildPublicLink('help/rules', '', array('confirm' => 'conversations'))
				);
			}
		}

		return $response;
	}
}