<?php
class Brivium_AdvancedRules_ControllerPublic_Forum extends XFCP_Brivium_AdvancedRules_ControllerPublic_Forum
{

	public function actionIndex()
	{
		$response = parent::actionIndex();

		$options = XenForo_Application::get('options');
		$visitor = XenForo_Visitor::getInstance();

		$setup = $options->AdvancedRules_setup;

		if ($visitor['user_id'] > 0)
		{
			if($this->_getRuleModel()->requirePermission() &&  $setup['viewForum'] && !$visitor['advanced_rules'])
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
					XenForo_Link::buildPublicLink('help/rules')
				);
			}
		}
		
		return $response;
	}

	public function actionCreateThread()
	{
		$response = parent::actionCreateThread();

		$options = XenForo_Application::get('options');
		$visitor = XenForo_Visitor::getInstance();

		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);

		$forumId = $forum['node_id'];

		$this->_assertCanPostThreadInForum($forum);

		$setup = $options->AdvancedRules_setup;

		if ($visitor['user_id'] > 0)
		{
			if($this->_getRuleModel()->requirePermission($forum['node_id']) && $setup['createThread'] && !$visitor['advanced_rules'])
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
					XenForo_Link::buildPublicLink('help/rules', '', array('confirm' => 'create-thread'))
				);
			}
		}

		return $response;
	}
	protected function _getRuleModel()
	{
		return $this->getModelFromCache('Brivium_AdvancedRules_Model_Rule');
	}
}