<?php
class Brivium_AdvancedRules_ControllerPublic_Help extends XFCP_Brivium_AdvancedRules_ControllerPublic_Help
{
	public function actionRules()
	{
		$confirm = $this->_input->filterSingle('confirm', XenForo_Input::STRING);

		$rule = $confirm ? $confirm : '';

		$viewParams = array(
			'rule' => $rule,
			'redirect' => $this->getDynamicRedirect()
		);
		return $this->responseView('Brivium_AdvancedRules', 'advanced_rules', $viewParams);
	}

	public function actionConfirmRules()
	{
		$this->_assertPostOnly();

		$referer = $this->_input->filterSingle('redirect', XenForo_Input::STRING);
		$rule = $this->_input->filterSingle('rule', XenForo_Input::STRING);

		$visitor = XenForo_Visitor::getInstance();
		$options = XenForo_Application::get('options');

		if ($referer && preg_match('|^http(s)?://[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$|i',$referer) && (strlen($referer) >= strlen($options->boardUrl))) 
		{
			$redirect = $referer.$rule;
		}
		else 
		{
			$redirect = $options->boardUrl;
		}
		if ($rule == 'conversations') 
		{
			$redirect = XenForo_Link::buildPublicLink('conversations/add');
		}
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$dw->setExistingData($visitor['user_id']);
		$dw->set('advanced_rules', 1);
		$dw->save();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$redirect
		);
	}
}