<?php
class Brivium_AdvancedRules_ControllerPublic_Thread extends XFCP_Brivium_AdvancedRules_ControllerPublic_Thread
{

	public function actionIndex()
	{

		$response = parent::actionIndex();

		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($threadFetchOptions, $forumFetchOptions) = $this->_getThreadForumFetchOptions();
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId, $threadFetchOptions, $forumFetchOptions);

		$options = XenForo_Application::get('options');
		$visitor = XenForo_Visitor::getInstance();

		$userGroups = $options->AdvancedRules_userGroup;
		$setup = $options->AdvancedRules_setup;

		if ($visitor['user_id'] > 0)
		{
			if($this->_getRuleModel()->requirePermission($forum['node_id']) && $setup['viewThread'] && !$visitor['advanced_rules'])
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
					XenForo_Link::buildPublicLink('help/rules')
				);
			}
		}
		return $response;
	}

	protected function _getRuleModel()
	{
		return $this->getModelFromCache('Brivium_AdvancedRules_Model_Rule');
	}
}