<?php
class Brivium_AdvancedRules_Listener extends Brivium_BriviumLibrary_EventListeners
{
	public static function loadClassListener($class, &$extend)
	{
		switch($class){
			case 'XenForo_ControllerPublic_Help':
				$extend[] = 'Brivium_AdvancedRules_ControllerPublic_Help';
				break;
			case 'XenForo_ControllerPublic_Forum':
				$extend[] = 'Brivium_AdvancedRules_ControllerPublic_Forum';
				break;
			case 'XenForo_ControllerPublic_Thread':
				$extend[] = 'Brivium_AdvancedRules_ControllerPublic_Thread';
				break;
			case 'XenForo_ControllerPublic_Conversation':
				$extend[] = 'Brivium_AdvancedRules_ControllerPublic_Conversation';
				break;
			case 'XenForo_DataWriter_User':
				$extend[] = 'Brivium_AdvancedRules_DataWriter_User';
				break;
		}
	}

    public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template) 
    {
    	$options = XenForo_Application::get('options');
		switch ($hookName)
		{     
			case 'navigation_tabs_forums':
				if ($options->AdvancedRules_navTab)
				{
					$contents .= '<li><a href="' . XenForo_Link::buildPublicLink('help/rules') . '">' . new XenForo_Phrase('advanced_rules') . '</a></li>';
				}
				break;
			case 'navigation_tabs_help':
				$contents .= '<li><a href="' . XenForo_Link::buildPublicLink('help/rules') . '">' . new XenForo_Phrase('advanced_rules') . '</a></li>';
				break;
		}
		self::_templateHook($hookName, $contents, $hookParams, $template);
	}
	
}