<?php

class Brivium_AssignStyle_Option_StyleChooser
{
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$value = $preparedOption['option_value'];

		$editLink = $view->createTemplateObject('option_list_option_editlink', array(
			'preparedOption' => $preparedOption,
			'canEditOptionDefinition' => $canEdit
		));

		$styleModel = self::_getStyleModel();

		$styleOptions = $styleModel->getStylesForOptionsTag(
			$value
		);

		return $view->createTemplateObject('BriviumAssignStyle_option_styleChooser', array(
			'fieldPrefix' => $fieldPrefix,
			'listedFieldName' => $fieldPrefix . '_listed[]',
			'preparedOption' => $preparedOption,
			'formatParams' => $styleOptions,
			'editLink' => $editLink
		));
	}

	protected static function _getStyleModel()
	{
		return XenForo_Model::create('XenForo_Model_Style');
	}
}