<?php

class Brivium_AttachmentEssential_ControllerAdmin_Attachment extends XFCP_Brivium_AttachmentEssential_ControllerAdmin_Attachment
{
	public function actionStatistics()
	{
		if ($this->_input->inRequest('delete_selected'))
		{
			return $this->responseReroute(__CLASS__, 'delete');
		}

		$input = $this->_getStatisticsFilterParams();
		
		$attachmentModel = $this->_getAttachmentModel();
		
		switch ($input['mode'])
		{
			case 'lastDownload':
				$fetchOptions = array(
					'join' => Brivium_AttachmentEssential_Model_Attachment::FETCH_DOWNLOAD,
					'order' => 'download',
					'limit' => '10'
				);
				break;

			case 'mostPopular';
			default:
				$input['mode'] = 'mostPopular';
				$fetchOptions = array(
					'join' => XenForo_Model_Attachment::FETCH_USER,
					'order' => 'view',
					'limit' => '10'
				);
		}
		
		$attachments = $attachmentModel->getAttachments(array(), $fetchOptions);
		
		$viewParams = array(
			'contentTypes' => $attachmentModel->getAttachmentHandlerContentTypeNames(),
			
			'mode' => $input['mode'],
			'attachments' => $attachmentModel->prepareAttachments($attachments, true),
			'total' => $attachmentModel->countAttachments()
		);

		return $this->responseView('Brivium_AttachmentEssential_ViewAdmin', 'AttachmentEssential_attachments_list', $viewParams);
	}

	public function actionUserStatistics()
	{
		$input = $this->_getStatisticsFilterParams();
		
		$attachmentEssentialModel = $this->_getAttachmentEssentialModel();
		
		$fetchOptions = array(
			'join' => Brivium_AttachmentEssential_Model_AttachmentEssential::FETCH_USER,
			'limit' => '10'
		);

		$users = $attachmentEssentialModel->getMostDownload(array(), $fetchOptions);
		
		$viewParams = array(
			'users' => $users
		);

		return $this->responseView('Brivium_AttachmentEssential_ViewAdmin', 'AttachmentEssential_users_list', $viewParams);
	}

	protected function _getStatisticsFilterParams()
	{
		return $this->_input->filter(array(
			'mode' => XenForo_Input::STRING,
		));
	}
	
	protected function _getAttachmentModel()
	{
		return $this->getModelFromCache('XenForo_Model_Attachment');
	}
	
	protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}
}